<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class igalleryControllerCategories extends JControllerAdmin
{
    public function &getModel($name = 'Icategory', $prefix = 'IgalleryModel',$config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	function add_category_redirect()
	{
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=icategory', false) );
	}
	
	function copy()
	{
		if(!igGeneralHelper::authorise('core.create'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}

		$model = $this->getModel();

		if($model->copy())
        {
            $msg = JText::_('SUCCESSFULLY_COPIED');
        }
        else
        {
            $msg = $model->getError();
        }
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=categories'.$this->Itemid, false), $msg);
	}
	
	function delete()
	{
        $cid = $this->input->get('cid', array(), 'INT');

        if (!is_array($cid) || count($cid) < 1)
        {
            JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
        }
        else
        {
            foreach($cid as $id)
            {
                if(!igGeneralHelper::authorise('core.delete', $id))
                {
                    $this->setMessage(JText::_('JERROR_CORE_DELETE_NOT_PERMITTED'));
                    return false;
                }

                $model = $this->getModel();

                if($model->delete($id))
                {
                    $this->setMessage(JText::plural($this->text_prefix . '_N_ITEMS_DELETED', count($cid)));
                }
                else
                {
                    $this->setMessage($model->getError(), 'error');
                }
            }
        }

        $this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
    }
	
	function publish()
	{
	    $cid = $this->input->get('cid', array(), 'INT');
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.edit.state', $cid[$i]))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
				return false;
			}
		}
		
		parent::publish();
		
	}
	
	function saveorder()
	{
        $cid = $this->input->get('cid', array(), 'INT');

		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.edit.state', $cid[$i]))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
				return false;
			}
		}

		$order = array_values( $this->input->get('orderbox', array()) );
        $this->input->set('order', $order);
        $this->input->post->set('order', $order);

        parent::saveorder();
	}
	
	function moderate()
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$model = $this->getModel();
		if(!$model->moderate(1)) 
		{
            $this->setMessage($model->getError() );
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=categories', false) );
	}
	
	
	function unmoderate()
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$model = $this->getModel();
		if(!$model->moderate(0)) 
		{
            $this->setMessage($model->getError());
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=categories', false) );
	}

    function change_owner()
    {
        $cid = $this->input->get('cid', array(), 'INT');

        for($i=0; $i<count($cid); $i++)
        {
            if(!igGeneralHelper::authorise('core.edit.state', $cid[$i]))
            {
                $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
            }
        }

        $model = $this->getModel();

        if($model->change_owner())
        {
            $this->setMessage(JText::_('SUCCESSFULLY_SAVED'));
        }
        else
        {
            $this->setMessage($model->getError(), 'error');
        }

        $this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_list, false));
    }

    function change_profile()
    {
        $cid = $this->input->get('cid', array(), 'INT');

        for($i=0; $i<count($cid); $i++)
        {
            if(!igGeneralHelper::authorise('core.edit.state', $cid[$i]))
            {
                $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
            }
        }

        $model = $this->getModel();

        if($model->change_profile())
        {
            $this->setMessage(JText::_('SUCCESSFULLY_SAVED'));
        }
        else
        {
            $this->setMessage($model->getError(), 'error');
        }

        $this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_list, false));
    }

}