<?php
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

jimport('joomla.application.component.controlleradmin');

class igalleryControllerimages extends JControllerAdmin
{
	public function &getModel($name = 'Image', $prefix = 'IgalleryModel', $config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	function copy_move()
	{
		if(!igGeneralHelper::authorise('core.create', $this->input->get('catid',0,'INT')))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		
		$msg = '';
		if(!$model->copy_move()) 
		{
            $this->setMessage($model->getError(),'error');
		}
		else
		{
			$copyMove = $this->input->get('copy_move','copy','CMD');
			$msg = $copyMove == 'move' ? JText::_('SUCCESSFULLY_MOVED') : JText::_('SUCCESSFULLY_COPIED');
		}
	
		$this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
	}
	
	function add_tags()
	{
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT')))
        {
            $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
        }
		
		$model = $this->getModel();
		$msg = '';
		if( !$model->add_tags() ) 
		{
            $msg = $model->getError();
		}
		else
		{
			$msg = JText::_('SUCCESSFULLY_ADDED');
		}
	
		$this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
	}
	
	function remove_tags()
	{
		if( !igGeneralHelper::authorise('core.edit') )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		$msg = '';
		if( !$model->remove_tags() ) 
		{
            $msg = $model->getError();
		}
		else
		{
			$msg = JText::_('SUCCESSFULLY_REMOVED');
		}
	
		$this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
	}

    function change_access()
    {
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT')))
        {
            $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
        }

        $model = $this->getModel();
        $msg = '';
        if( !$model->change_access() )
        {
            $msg = $model->getError();
        }
        else
        {
            $msg = JText::_('SUCCESSFULLY_SAVED');
        }

        $this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
    }

    function change_owner()
    {
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT')))
        {
            $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
        }

        $model = $this->getModel();
        $msg = '';
        if( !$model->change_owner() )
        {
            $msg = $model->getError();
        }
        else
        {
            $msg = JText::_('SUCCESSFULLY_SAVED');
        }

        $this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
    }

    function change_link()
    {
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT')))
        {
            $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
        }

        $model = $this->getModel();
        $msg = '';
        if( !$model->change_link() )
        {
            $msg = $model->getError();
        }
        else
        {
            $msg = JText::_('SUCCESSFULLY_SAVED');
        }

        $this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), $msg);
    }
	
	function browserUpload()
	{
		if(!igGeneralHelper::authorise('core.create', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		for($i=0; $i<count($_FILES['uploads']['name']); $i++)
		{
			$fileName = $_FILES['uploads']['name'][$i];
			$tmpPath = $_FILES['uploads']['tmp_name'][$i];
			$uploadError = $_FILES['uploads']['error'][$i];
			
			if(! $fileData = igFileHelper::processUploadedImage($fileName, $tmpPath, $uploadError, 'igallery_img', true) )
			{
				$this->setRedirect('index.php?option=com_igallery&controller=igphoto&catid='.$this->input->get('catid',0,'INT'));
				return false;
			}
			
			$model = $this->getModel();

			$category = $model->getCategory($this->input->get('catid',0,'INT'));
			$profile = $model->getProfile($category->profile);

			if(!igFileHelper::makeResizedOnUpload($fileData, $profile, true))
			{
				return false;
			}
			
			if (!$model->store($fileData) ) 
			{
				return false;
			}
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false) );
	}
	
	function publish()
	{
		$cid = $this->input->get('cid', array(), 'INT');
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.edit.state', null, $cid[$i]))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
				return false;
			}
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::publish();
	}
	
	function reorder()
	{	
		$cid = $this->input->get('cid', array(), 'INT');
		
		if(!igGeneralHelper::authorise('core.edit.state', null, (int)$cid[0]))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::reorder();
	}
	
	function saveorder()
	{
		$cid = $this->input->get('cid', array(), 'INT');
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.edit.state', null, $cid[$i]))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
				return false;
			}
		}


        $order = array_values( $this->input->get('orderbox', array()) );
        $this->input->set('order', $order);
        $this->input->post->set('order', $order);

		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::saveorder();
	}
	
	function delete()
	{
		if(!igGeneralHelper::authorise('core.delete', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::delete();
	}
	
	function rotate()
	{
		if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$model = $this->getModel();
	
		if( !$model->rotate() ) 
		{
			$msg = '';
			$this->setMessage($model->getError(),'error');
		}
		
		$this->setRedirect(JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false) );
	}
	
	function assignMenuImage()
	{
		if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
	
		if( !$model->assignMenuImage() ) 
		{
			$this->setMessage($model->getError(),'error');
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false) );
	}
	
	function moderate()
	{
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		if(!$model->moderate(1)) 
		{
            $this->setMessage($model->getError(),'error');
		}
		
		$this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'));
	}
	
	
	function unmoderate()
	{
        if(!igGeneralHelper::authorise('core.edit.state', $this->input->get('catid',0,'INT') ) )
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		if(!$model->moderate(0)) 
		{
            $this->setMessage($model->getError(),'error');
		}
		
		$this->setRedirect('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'));
	}

}	