<?php
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class IgalleryControllerProfile extends JControllerForm
{
	function save($key = null, $urlVar = null)
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$app = JFactory::getApplication();
		$data = $this->input->get('jform', array(), 'array');
        foreach($data as $key => $value)
        {
            if(!is_array($data[$key]))
            {
                $data[$key] = JComponentHelper::filterText($value);
            }
        }
		$id = (int)$data['id'];
			
		if( empty($id[0]) )
		{
			if(!igGeneralHelper::authorise('core.create'))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
			}
		}
		else
		{
			if(!igGeneralHelper::authorise('core.edit'))
			{
				$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
			}
		}
		 
		if(strlen($_FILES['jform']['name']['watermark_filename']) > 2 )
		{  
			$fileName = $_FILES['jform']['name']['watermark_filename'];
			$tmpPath = $_FILES['jform']['tmp_name']['watermark_filename'];
			$uploadError = $_FILES['jform']['error']['watermark_filename'];
			
			if(!$uploadedFile = igUploadHelper::upload_file($fileName, $tmpPath, $uploadError, IG_WATERMARK_PATH, true) )
			{
				return false;
			}
			
			$data['watermark_filename'] = $uploadedFile;
		}
		
		$model = $this->getModel();
		$form = $model->getForm($data, false);

		if(!$form)
		{
			$app->enqueueMessage($model->getError(), 'error');
			return false;
		}

		$validData = $model->validate($form, $data);

		if($validData === false)
		{
			$errors	= $model->getErrors();
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
			{
			    $app->enqueueMessage($errors[$i], 'warning');
			}

			$this->setRedirect('index.php?option=com_igallery&view=profile&id='.$id, false);
			return false;
		}
		
		if( !$model->save($validData) )
		{
            $msg = $model->getError();
		}
		else 
		{
			$msg = JText::_('SUCCESSFULLY_SAVED');
		} 
		
		switch($this->task)
		{
			case 'apply':
			$url = 'index.php?option=com_igallery&view=profile&id='.$id;
			break;
			
			case 'save':
			$url = 'index.php?option=com_igallery&view=profiles';
		}
	
		$this->setRedirect($url, $msg);
	}
	
	function remove()
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		if(!igGeneralHelper::authorise('core.delete'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		
		if( !$model->checkAssigned() )
		{
			$this->setRedirect('index.php?option=com_igallery&view=profiles');
			return;
		}
		
		if( !$model->delete() )
		{
			$msg = $model->getError();
		}
		else 
		{
			$msg = JText::_('SUCCESSFULLY_SAVED');
		}
		
		$this->setRedirect('index.php?option=com_igallery&view=profiles', $msg);
	}
	
}