<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class igalleryControllerProfiles extends JControllerAdmin
{
	public function &getModel($name = 'Profile', $prefix = 'IgalleryModel',$config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	function add_profile_redirect()
	{
		$this->setRedirect('index.php?option=com_igallery&view=profile');
	}
	
	function copy()
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		if(!igGeneralHelper::authorise('core.create'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}

		$model = $this->getModel();
		
		$msg = '';
		if ($model->copy()) 
		{
			$msg = JText::_('SUCCESSFULLY_COPIED');
		}
		
		$this->setRedirect('index.php?option=com_igallery&view=profiles', $msg);
	}
	
	function delete()
	{
		if(!igGeneralHelper::authorise('core.admin'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		if(!igGeneralHelper::authorise('core.delete'))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR')); return false;
		}
		
		$model = $this->getModel();
		
		if( !$model->checkAssigned() )
		{
			$this->setRedirect('index.php?option=com_igallery&view=profiles');
			return;
		}
		
		parent::delete();
	}
    
}