<?php
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Http\HttpFactory;
use Joomla\Registry\Registry;

class igFileHelper
{
	static function processUploadedImage($fileName, $tmpPath, $uploadError, $tableName, $refresh, $imageToReplaceId=0)
    {
        if(!$uploadedFile = igUploadHelper::upload_file($fileName, $tmpPath, $uploadError, IG_TEMP_PATH, $refresh) )
		{
			return false;
		}

		$params = JComponentHelper::getParams('com_igallery');

		//get the folder path
		$folderName = igFileHelper::getFolderName();
		igFileHelper::makeFolder(IG_ORIG_PATH.'/'.$folderName);
		$destFolderPath = IG_ORIG_PATH.'/'.$folderName;

		//make the filename
		$destFile = igFileHelper::checkUniqueName($destFolderPath, $uploadedFile);

		//make the folder paths
		$sourcePath = IG_TEMP_PATH.'/'.$uploadedFile;
		$destPath = $destFolderPath.'/'.$destFile;

        if(JFile::getExt($fileName) == 'svg')
        {
            if(!JFile::copy($sourcePath, $destPath))
            {
                igFileHelper::raiseError($sourcePath.' -> '.$destPath .' '. JText::_( 'Error Moving File To Directory' ), $refresh);
                return false;
            }
        }
        else
        {
            $imageinfo = getimagesize($sourcePath);
            $maxServerWidth = $params->get('server_max_width', 2100);
            $maxServerHeight = $params->get('server_max_height', 1600);
            $rotation = self::getExifRotation($sourcePath);

            if( ($imageinfo[0] > $maxServerWidth) || ($imageinfo[1] > $maxServerHeight) || $rotation != 0)
            {
                if(!igFileHelper::makeImage($sourcePath, $destPath, $maxServerWidth, $maxServerHeight, 95, $refresh, 0, $rotation) )
                {
                    return false;
                }
            }
            else
            {
                if(!JFile::copy($sourcePath, $destPath))
                {
                    igFileHelper::raiseError($sourcePath.' -> '.$destPath .' '. JText::_( 'Error Moving File To Directory' ), $refresh);
                    return false;
                }
            }
        }

        $fileData = array();
		$fileData['filename'] = $destFile;
        $fileData['folder'] = $folderName;

        if(JFile::getExt($destFile) != 'svg')
        {
            if($params->get('import_exif_data', 0) == 1)
            {
                $fileData['exif_des'] = igMetadataHelper::getExifData($sourcePath);
            }

            if($params->get('import_iptc_data', 0) == 1)
            {
                $fileData['iptc_des'] = igMetadataHelper::getIptcData($sourcePath);
            }

            if($params->get('import_iptc_tags', 0) == 1)
            {
                $fileData['iptc_tags'] = igMetadataHelper::getIptcTags($sourcePath);
            }

            if($params->get('import_iptc_title', 0) == 1)
            {
                $fileData['iptc_title'] = igMetadataHelper::getIptcTitle($sourcePath);
            }

            $fileData['exif_extra'] = igMetadataHelper::getExifExtra($sourcePath);
        }

        if(JFile::exists($sourcePath))
		{
			JFile::delete($sourcePath);
		}

		return $fileData;

    }
    
    static function processImportedImage($relPath)
    {
        $fullPath = JPATH_SITE.'/'.$relPath;
        $fileData = array();
        $params = JComponentHelper::getParams('com_igallery');
        $moveImage = $params->get('import_behavior', 'move') == 'move' ? 1 : 0;

        if( !igUploadHelper::checkExtension($fullPath, false) )
		{
		    return false;
		}

        if(JFile::getExt($fullPath) != 'svg')
        {
            if( !igUploadHelper::checkIsImage($fullPath, false) )
            {
                return false;
            }
        }

        $slash = strrpos($fullPath, '/') + 1;
        $filename = substr($fullPath, $slash);

    	if($moveImage)
        {
            $filename = igUploadHelper::replaceSpecial($filename);

            $folderName = igFileHelper::getFolderName();
            igFileHelper::makeFolder(IG_ORIG_PATH.'/'.$folderName);
            $destFolderPath = IG_ORIG_PATH.'/'.$folderName;
            $destFile = igFileHelper::checkUniqueName($destFolderPath, $filename);
            $destPath = $destFolderPath.'/'.$destFile;

            if(JFile::getExt($fullPath) != 'svg')
            {
                $imageinfo = getimagesize($fullPath);
                $maxServerWidth = $params->get('server_max_width', 2100);
                $maxServerHeight = $params->get('server_max_height', 1600);
                $rotation = self::getExifRotation($fullPath);

                if($imageinfo[0] > $maxServerWidth || $imageinfo[1] > $maxServerHeight)
                {
                    if(!igFileHelper::makeImage($fullPath, $destPath, $maxServerWidth, $maxServerHeight, 95, false, 0, $rotation) )
                    {
                        return false;
                    }
                }
                else
                {
                    if(!JFile::copy($fullPath, $destPath))
                    {
                        igFileHelper::raiseError($fullPath.' -> '.$destPath .' '. JText::_( 'Error Moving File To Directory' ), false);
                        return false;
                    }
                }
            }
            else
            {
                if(!JFile::copy($fullPath, $destPath))
                {
                    igFileHelper::raiseError($fullPath.' -> '.$destPath .' '. JText::_( 'Error Moving File To Directory' ), false);
                    return false;
                }
            }

            $fileData['filename'] = $destFile;

        }
		else
        {
            igFileHelper::getFolderName();
            $fileData['filesrc'] = $relPath;
            $fileData['filename'] = $filename;
        }

        if(JFile::getExt($fullPath) != 'svg')
        {
            if($params->get('import_exif_data', 0) == 1)
            {
                $fileData['exif_des'] = igMetadataHelper::getExifData($fullPath);
            }

            if($params->get('import_iptc_data', 0) == 1)
            {
                $fileData['iptc_des'] = igMetadataHelper::getIptcData($fullPath);
            }

            if($params->get('import_iptc_tags', 0) == 1)
            {
                $fileData['iptc_tags'] = igMetadataHelper::getIptcTags($fullPath);
            }

            if($params->get('import_iptc_title', 0) == 1)
            {
                $fileData['iptc_title'] = igMetadataHelper::getIptcTitle($fullPath);
            }

            $fileData['exif_extra'] = igMetadataHelper::getExifExtra($fullPath);
        }

		return $fileData;

    }

    static function checkGalleryFolderExists($catId,$newName=false)
    {
        $db = JFactory::getDbo();
        $query = 'SELECT * from #__igallery where id = '.(int)$catId;
        $db->setQuery($query);
        $row = $db->loadObject();

        if(empty($row->folder) || $newName)
        {
            $oldFolderName = $row->folder;

            $lang = JFactory::getLanguage();
            $folderName = $lang->transliterate($row->name);
            $folderName = preg_replace('/[^A-Za-z0-9.]/', '-', $folderName);
            $folderName = preg_replace('/-+/', '-', $folderName);
            $folderName = substr($folderName,0,48);
            $folderName = $folderName.'-'.$row->id;
            $folderPath = IG_ORIG_PATH.'/'.$folderName;

            if($newName)
            {
                if($folderName != $oldFolderName)
                {
                    if( !JFolder::move(IG_ORIG_PATH.'/'.$oldFolderName, $folderPath) )
                    {
                        JFactory::getApplication()->enqueueMessage('error moving folder to:'.$folderPath,'error' );
                        return false;
                    }

                    if( !JFolder::move(IG_RESIZE_PATH.'/'.$oldFolderName, IG_RESIZE_PATH.'/'.$folderName) )
                    {
                        JFactory::getApplication()->enqueueMessage('error moving folder to:'.IG_RESIZE_PATH.'/'.$folderName,'error' );
                        return false;
                    }
                }
            }
            else
            {
                if( !JFolder::exists($folderPath) )
                {
                    if( !JFolder::create($folderPath, 0755) )
                    {
                        JFactory::getApplication()->enqueueMessage($folderPath .' '. JText::_( 'FOLDER_CREATE_ERROR' ),'error' );
                        return false;
                    }
                }
            }


            $query = 'UPDATE #__igallery SET folder = '.$db->Quote($folderName).' WHERE id = '.(int)$catId;
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                return false;
            }

            return $folderName;
        }

        return $row->folder;

    }

    static function processVideoUrl($videoUrl)
    {
        $urlParts = parse_url($videoUrl);

        if(strpos($urlParts['host'], 'youtu') !== false)
        {
            preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user)\/))([^\?&\"'>]+)/", $videoUrl, $matches);
            $imageUrl = 'http://img.youtube.com/vi/'.$matches[1].'/maxresdefault.jpg';

            $youtubeInfoUrl = "https://www.youtube.com/oembed?url=".$videoUrl."&format=json";
            $options = new Registry;
            $options->set('userAgent', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0');
            $response = HttpFactory::getHttp($options)->get($youtubeInfoUrl);
            if($response->code != 200)
            {
                JFactory::getApplication()->enqueueMessage('Error Unable to open the url: '.$youtubeInfoUrl.' Response code: '.$response->code,'error');
                return false;
            }

            $videoInfoArray = json_decode($response->body, true);
            $title = $videoInfoArray['title'];
            $embedCode = $videoInfoArray['html'];
        }
        else
        {
            $vimeoInfoUrl = "https://vimeo.com/api/oembed.json?url=".urlencode($videoUrl);
            $options = new Registry;
            $options->set('userAgent', 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');
            $response = HttpFactory::getHttp($options)->get($vimeoInfoUrl);
            if($response->code != 200)
            {
                JFactory::getApplication()->enqueueMessage('Error Unable to open the url:'.$vimeoInfoUrl.' Response code: '.$response->code,'error');
                return false;
            }

            $videoInfoArray = json_decode($response->body, true);
            $title = $videoInfoArray['title'];
            $embedCode = $videoInfoArray['html'];

            $options = new Registry;
            $options->set('userAgent', 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');
            $response = HttpFactory::getHttp($options)->get($videoUrl);

            if($response->code == 200)
            {
                if(preg_match_all('/<meta([^>]+)content="([^>]+)>/', $response->body, $matches))
                {
                    $doc = new DOMDocument();
                    @$doc->loadHTML('<?xml encoding="utf-8" ?>'.implode($matches[0]));
                    $tags = array();
                    foreach($doc->getElementsByTagName('meta') as $metaTag)
                    {
                        if($metaTag->getAttribute('name') != "")
                        {
                            $tags[$metaTag->getAttribute('name')] = $metaTag->getAttribute('content');
                        }
                        elseif ($metaTag->getAttribute('property') != "")
                        {
                            $tags[$metaTag->getAttribute('property')] = $metaTag->getAttribute('content');
                        }
                    }
                }
                $ogImage = $tags['og:image'];
                $parts1 = explode('src0=',$ogImage);
                $parts2 = explode('&src1',$parts1[1]);
                $imageUrl = urldecode($parts2[0]);
                $imageUrl = empty(JFile::getExt($imageUrl)) ? $imageUrl.'.png' : $imageUrl;
            }
            else
            {
                $imageUrl = $videoInfoArray['thumbnail_url'];
	            $imageUrl = empty(JFile::getExt($imageUrl)) ? $imageUrl.'.png' : $imageUrl;
            }
        }

        if(function_exists('transliterator_transliterate'))
        {
            $title = transliterator_transliterate('Any-Latin;Latin-ASCII;',$title);
        }
        else
        {
            $lang = JFactory::getLanguage();
            $title = $lang->transliterate($title);
        }

        $title = preg_replace('/\s+/', ' ',$title);
        $title = preg_replace('/[^A-Za-z0-9]/', '-', $title);
        $title = trim(preg_replace('/-+/', '-', $title), '-');
        $title = trim($title);
        if(strlen($title) > 35)
        {
            $title = substr($title, 0, strrpos(substr($title, 0, 35), '-'));
        }

        $ext = JFile::getExt($imageUrl);
        $filename = strtolower($title.'.'.$ext);

        //get the folder path
        $folderName = igFileHelper::getFolderName();
        igFileHelper::makeFolder(IG_ORIG_PATH.'/'.$folderName);
        $destFolderPath = IG_ORIG_PATH.'/'.$folderName;

        //make the filename
        $destFile = igFileHelper::checkUniqueName($destFolderPath, $filename);
        $destPath = $destFolderPath.'/'.$destFile;

        if(!igUploadHelper::checkExtension($imageUrl,false,false))
        {
            JFactory::getApplication()->enqueueMessage('Invalid file format:'.$imageUrl,'error');
            return false;
        }

        $options = new Registry;
        $options->set('userAgent', 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');
        $response = HttpFactory::getHttp($options)->get($imageUrl);

        JFile::write($destPath, $response->body);

        if(filesize($destPath) < 5000 && strpos($urlParts['host'], 'youtu') !== false)
        {
            JFile::delete($destPath);
            $url = 'http://img.youtube.com/vi/'.$matches[1].'/sddefault.jpg';
            $options = new Registry;
            $options->set('userAgent', 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');
            $response = HttpFactory::getHttp($options)->get($url);

            JFile::write($destPath, $response->body);

            if(filesize($destPath) < 5000)
            {
                JFile::delete($destPath);
                $url = $videoInfoArray['thumbnail_url'];
                $options = new Registry;
                $options->set('userAgent', 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');
                $response = HttpFactory::getHttp($options)->get($url);
                JFile::write($destPath, $response->body);
            }
        }

        $fileData = array();
        $fileData['filename'] = $destFile;
        $fileData['embed_code'] = $embedCode;

        return $fileData;
    }

    static function makeResizedOnUpload($fileData, $profile, $refresh)
	{
		if(!igFileHelper::originalToResized($fileData['filename'], $fileData['folder'], '', $profile->thumb_width,
		$profile->thumb_height, $profile->img_quality, $profile->crop_thumbs, 0, $profile->round_thumb, $profile->round_fill,'center_middle',0,'','','','','',100,0,$refresh) )
		{
			return false;
		}

		if(!igFileHelper::originalToResized($fileData['filename'], $fileData['folder'], '', $profile->max_width,
		$profile->max_height, $profile->img_quality, $profile->crop_main, 0, $profile->round_large, $profile->round_fill,'center_middle',
		$profile->watermark, $profile->watermark_text, $profile->watermark_text_color, $profile->watermark_text_size, $profile->watermark_filename,
		$profile->watermark_position, $profile->watermark_transparency, 0, $refresh) )
		{
			return false;
		}

        if($profile->lightbox == 1 && $profile->lbox_show_thumbs == 1)
        {
            if (!igFileHelper::originalToResized($fileData['filename'], $fileData['folder'], '', $profile->lbox_thumb_width,
                $profile->lbox_thumb_height, $profile->img_quality, $profile->lbox_crop_thumbs, 0, $profile->round_thumb, $profile->round_fill, 'center_middle', 0, '', '', '', '', '', 100, 0, $refresh)) {
                return false;
            }
        }

        if($profile->lightbox == 1)
        {
            if(!igFileHelper::originalToResized($fileData['filename'], $fileData['folder'], '', $profile->lbox_max_width,
            $profile->lbox_max_height, $profile->img_quality, $profile->crop_lbox, 0, $profile->round_large, $profile->round_fill,'center_middle',
            $profile->watermark, $profile->watermark_text, $profile->watermark_text_color, $profile->watermark_text_size,  $profile->watermark_filename,
            $profile->watermark_position, $profile->watermark_transparency, 0, $refresh) )
            {
                return false;
            }
        }


		return true;
	}

	static function originalToResized($fileName, $folderName, $fileSrc, $width, $height, $quality, $crop, $rotation, $round, $roundFill, $cropPosition='center_middle',
    $watermark=0, $wmText='', $wmTextColor='', $wmTextSize='', $wmFilename='', $wmPosition='', $wmTrans=100, $filesize=0, $refresh=true )
    {
        $params = JComponentHelper::getParams('com_igallery');

        if(empty($folderName))
        {
            $increment = igFileHelper::getIncrementFromFilename($fileName);
            $folderName = igFileHelper::getFolderName($increment);
        }

        if(!empty($fileSrc))
        {
            $sourceFile = JPATH_SITE.'/'.$fileSrc;
        }
        else
        {
            $sourceFile = IG_ORIG_PATH.'/'.$folderName.'/'.$fileName;
        }

        if(JFile::getExt($fileName) == 'svg')
        {
            $fullFileName = $fileName;
            $destFile = $sourceFile;

            $sizes = self::getSVGdimensions($sourceFile);
            $origWidth = $sizes[0];
            $origHeight = $sizes[1];

            $origRatio = round($origWidth/$origHeight);
            $targetRatio = round($width/$height);

            if($origRatio > $targetRatio)
            {
                $newWidth = $width;
                $newHeight = round( ($newWidth/$origWidth)*$origHeight);
            }
            else
            {
                $newHeight = $height;
                $newWidth = round(($newHeight/$origHeight)*$origWidth);
            }

            $imgSize = array($newWidth,$newHeight);

        }
        else
        {
            $fullFileName = igFileHelper::makeFileName($fileName, $width, $height, $quality, $crop, $rotation,
            $round, $roundFill, $cropPosition, $watermark, $wmPosition, $wmTrans, $wmText, $wmTextColor, $wmTextSize, $wmFilename);

            if($params->get('output_format', 'match') == 'webp')
            {
                $fullFileName = JFile::stripExt($fullFileName).'.webp';
            }

            $destFile = IG_RESIZE_PATH.'/'.$folderName.'/'.$fullFileName;

            if(! JFile::exists($destFile) )
            {
                if(!JFile::exists($sourceFile) )
                {
                    igFileHelper::raiseError('The source file: '.$sourceFile. ' does not exist, please delete/reupload this image.', $refresh);
                    return true;
                }

                if( !@is_array( getimagesize($sourceFile) ) )
                {
                    igFileHelper::raiseError('The source file: '.$sourceFile. ' is not valid, please delete/reupload this image.', $refresh);
                    return true;
                }

                igFileHelper::makeFolder(IG_RESIZE_PATH.'/'.$folderName);

                if(!igFileHelper::makeImage($sourceFile, $destFile, $width, $height, $quality, $refresh,
                $crop, $rotation, $round, $roundFill, $cropPosition, $watermark, $wmText, $wmTextColor, $wmTextSize, $wmFilename, $wmPosition, $wmTrans) )
                {
                    return false;
                }
            }

            $imgSize = getimagesize($destFile);

            if( empty($imgSize[0]) || empty($imgSize[1]) )
            {
                igFileHelper::raiseError('Error: the image dimensions of the file '.$destFile.' can not be read, please delete/reupload this image.', $refresh);
                return true;
            }
        }


		$fileArray = array();
		$fileArray['fullFileName'] = $fullFileName;
		$fileArray['folderName'] = $folderName;
        $fileArray['baseFolderServerPath'] = JFile::getExt($fileName) == 'svg' ? IG_ORIG_PATH : IG_RESIZE_PATH;
        $fileArray['baseFolderName'] = JFile::getExt($fileName) == 'svg' ? IG_IMAGE_HTML_ORIG : IG_IMAGE_HTML_RESIZE;
        $fileArray['baseFolderNameAbsolute'] = JFile::getExt($fileName) == 'svg' ? IG_IMAGE_HTML_ORIG_ABSOLUTE : IG_IMAGE_HTML_RESIZE_ABSOLUTE;
		$fileArray['width'] = $imgSize[0];
		$fileArray['height'] = $imgSize[1];

		if($filesize == 1)
		{
		   $size = filesize($destFile);
		   $fileArray['filesize'] = $size;
		}

		return $fileArray;
    }

    static function deleteImage($fileName, $deleteOrig, $folderName, $fileSys)
    {
        if($deleteOrig)
        {
            if($fileSys == 0)
            {
                $increment = igFileHelper::getIncrementFromFilename($fileName);
                $folderInc = igFileHelper::getFolderName($increment);
                $path = IG_ORIG_PATH . '/' . $folderInc . '/' . $fileName;
                if (JFile::exists($path))
                {
                    $folderName = $folderInc;
                    JFile::delete($path);
                }
            }
            else
            {
                $path = IG_ORIG_PATH.'/'.$folderName.'/'.$fileName;
                JFile::delete($path);
            }
        }


        $OrigPattern = JFile::stripExt($fileName);
        $OrigPatternLength = strlen($OrigPattern);
        
        $resizedFolder = IG_RESIZE_PATH.'/'.$folderName;
        $filesArray = JFolder::files($resizedFolder);

        if(!is_array($filesArray)){return;}
        
        for($i=0; $i<count($filesArray); $i++)
        {
            if( substr($filesArray[$i], 0, $OrigPatternLength) == $OrigPattern)
            {
                JFile::delete($resizedFolder.'/'.$filesArray[$i]);
            }
        }
        
    }
    
    static function getFileIncrement($tableName)
	{
	    $db = JFactory::getDBO();
	    $prefix = $db->getPrefix();
	    $query =  "SHOW TABLE STATUS LIKE '".$prefix.$tableName."'";
	    $db->setQuery($query);
        $row = $db->loadObject();
        return $row->Auto_increment;
	}

    static function getIncrementFromFilename($fileName)
	{
	    if( preg_match_all('/-[0-9]+/',$fileName, $matches) != 0)
        {
            $last = array_pop($matches[0]);
            $increment =  str_replace( '-', '', $last );
            return $increment;
        }
	    return false;
	}

	static function getFolderName($folderRef=0)
	{
	    if($folderRef==0)
        {
            $catId = JFactory::getApplication()->input->get('catid', 0,'INT');
            return igFileHelper::checkGalleryFolderExists($catId);
        }
	    else
        {
            $start = floor( ($folderRef/100) - 0.001) * 100;
            $end = ceil($folderRef /100 ) * 100;
            $folderName = ( ($start ) + 1).'-'.$end;

            return $folderName;
        }
	}

	static function makeFolder($folderPath)
    {
    	jimport('joomla.filesystem.folder');

        if ( !JFolder::exists($folderPath) )
    	{
    		if( !JFolder::create($folderPath, 0755) )
    		{
                JFactory::getApplication()->enqueueMessage($folderPath .' '. JText::_( 'FOLDER_CREATE_ERROR' ),'error' );
    			return false;
    		}
    	}
    }

	static function makeFileName($fileName, $width, $height, $quality, $crop, $rotation, $round, $roundFill,
    $cropPosition, $watermark, $wmPosition, $wmTrans, $wmText, $wmTextColor, $wmTextSize, $wmFilename)
	{
	    jimport('joomla.filesystem.file');
	    $fileNameExt = JFile::getExt($fileName);
		$fileNameNoExt = JFile::stripExt($fileName);
        
		$fullFileName = $fileNameNoExt.'-'.$width.'-'.$height.'-'.$quality;

		if($crop == 1)
		{
		    if( empty($cropPosition) || $cropPosition == 'center_middle')
            {
                $fullFileName.= '-c';
            }
            else
            {
                $wordsArray = explode('_',$cropPosition);
                $firstLetter =  substr($wordsArray[0],0,1);
                $secondLetter =  substr($wordsArray[1],0,1);
                $fullFileName.= '-c'.$firstLetter.$secondLetter;
            }
        }
		
		/*if($round == 1)
		{
		    $fullFileName.= '-rd';
		   
			if( preg_match("/jp/i", $fileNameExt) )
			{
				$fullFileName.= '-'.str_replace(',','-',$roundFill);
			}
		}*/
		
		if($rotation != 0)
		{
		   $fullFileName.= '-r'.$rotation;
		}
		
		if($watermark == 1 && ( strlen($wmFilename) > 1 || strlen($wmText) > 1) )
		{
			$fullFileName.= '-wm'.'-'.$wmPosition.'-'.$wmTrans;
			
			if(strlen($wmFilename) > 1)
			{
		    	$fullFileName.= '-'.preg_replace('/[^A-Za-z0-9]/', '', $wmFilename);
			}
			if(strlen($wmText) > 1)
			{
				$fullFileName.= '-'.preg_replace('/[^A-Za-z0-9]/', '', $wmText).'-'.str_replace(',','-',$wmTextColor).'-'.$wmTextSize;
			}
		}

		$fullFileName .= '.'.$fileNameExt;

		return $fullFileName;
	}

	static function addIncrement($file,$increment)
	{
	    $fileNameExt = JFile::getExt($file);
		$fileNameNoExt = JFile::stripExt($file);

		return $fileNameNoExt.'-'.$increment.'.'.$fileNameExt;
	}

	static function checkUniqueName($folderPath, $file)
	{
        if(JFile::exists($folderPath.'/'.$file) )
		{
		    $legacy = self::isLegacyFolder($folderPath.'/'.$file);

		    if($legacy)
            {
                $increment = igFileHelper::getIncrementFromFilename($file);
                $fileNameExt = JFile::getExt($file);
                $fileNameNoExt = JFile::stripExt($file);
                $fileNameNoIncrement = substr($fileNameNoExt, 0, strrpos($fileNameNoExt, '-'));

                $i=1;
                while(JFile::exists($folderPath.'/'.$fileNameNoIncrement.$i.'-'.$increment.'.'.$fileNameExt) )
                {
                    $i++;
                }
                $file = $fileNameNoIncrement.$i.'-'.$increment.'.'.$fileNameExt;
            }
		    else
            {
                $fileExt = JFile::getExt($file);
                $fileNameNoExt = JFile::stripExt($file);

                $file = $fileNameNoExt.rand(1,99).'.'.$fileExt;
            }

		}

		return $file;
	}

	static function isLegacyFolder($path)
    {
        $folder = basename($path);
        $parts = explode('-',$folder);
        if(count($parts) == 2 && ((int)$parts[0] > 0) && ((int)$parts[1] > 0 ))
        {
            return true;
        }
        return false;
    }

	static function makeImage($sourceFile, $destFile, $width, $height, $quality, $refresh,
	$crop=0, $rotation=0, $round=0, $roundFill='', $cropPosition='center_middle', $watermark=0, $wmText='', $wmTextColor='',
	$wmTextSize='', $wmFilename='', $wmPosition='', $wmTrans=100)
	{
        $quality = $quality > 90 ? 90 : $quality;
        $rotation = $rotation == 0 ? self::getExifRotation($sourceFile) : $rotation;
        $cropPosition = empty($cropPosition) ? 'center_middle' : $cropPosition;
        $cropPositionArray = explode('_', $cropPosition);
        $destExt = strtolower(JFile::getExt($destFile));
        $srcExt = strtolower(JFile::getExt($sourceFile));

		if( !extension_loaded('gd') && !function_exists('gd_info'))
		{
		    igFileHelper::raiseError('M1 0 :Please Check the PHP extension "GD Image Library" is installed on this server' , $refresh);
		    return false;
		}


		if($srcExt == 'webp' || $destExt == 'webp')
        {
            if(!function_exists('imagecreatefromwebp'))
            {
                igFileHelper::raiseError('Error, the PHP image library does not have support for WEBP images enabled, please go to the gallery component options, and change the "resized image format" to "same as uploaded", then ask your server admin to enable webp image support' , $refresh);
                return false;
            }
        }
		
	    if($width == 0 || $height == 0)
	    {
	        igFileHelper::raiseError('MI 1: '.JText::_('Image Width Or Height In Profile Settings Must Not Be Zero'), $refresh);
	        return false;
	    }
	    
		jimport('joomla.filesystem.file');
		require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/lib/gdimage/GdImage.php');

		if(! JFile::exists($destFile) )
		{
		    $imageinfo = getimagesize($sourceFile);
            $image = IGLImage::load($sourceFile);

            $params = JComponentHelper::getParams('com_igallery');
            $tryOriginal = $params->get('use_original', 0);
            
            if($tryOriginal == 1)
            {
                if($rotation == 0 && $round == 0 && $watermark == 0 && $crop == 0 && ($destExt == $srcExt))
	            {
			        if( $imageinfo[0] <= $width && $imageinfo[1] <= $height)
			        {
				        if(!JFile::copy($sourceFile, $destFile))
						{
							igFileHelper::raiseError($sourceFile.' -> '.$destFile .' '. JText::_( 'Error Moving File To Directory' ), $refresh);
							return false;
						}
						return true;
			        }
	            }
            }

            if($crop == 1 && $imageinfo[0] >= $width && $imageinfo[1] >= $height)
    		{
    			$image = $image->resize( (int)$width ,(int)$height, 'outside' )->crop( $cropPositionArray[0], $cropPositionArray[1], (int)$width, (int)$height );
    		}
    		else
    		{
    			$image = $image->resize( (int)$width, (int)$height, 'inside', 'down' );
    		}
    		
			if($rotation != 0)
            {
                if(!function_exists('imagerotate'))
                {
                    igFileHelper::raiseError(JFile::getName($sourceFile).': nee'/' rotating '.$rotation.' degress, Please Check the php function "imagerotate" is available on this server' , $refresh);
                }
                else
                {
                    $image = $image->rotate($rotation, null, false);
                }
            }

    		if($watermark == 1)
    		{
    			$positionArray = explode('_', $wmPosition);
	    		
    			switch($positionArray[0])
	    		{
		        	case 'left': $leftIndent = '+5'; break;
		        	case 'right': $leftIndent = '-5'; break;
		        	default: $leftIndent = '';
		    	}
		    	
    			switch($positionArray[1])
	    		{
		        	case 'top': $topIndent = '+5'; break;
		        	case 'bottom': $topIndent = '-5'; break;
		        	default: $topIndent = '';
		    	}
    			
    			if( strlen($wmText) > 0)
    			{
					$canvas = $image->getCanvas();
					$fontPath = IG_ADMINISTRATOR_COMPONENT.'/fonts/font.ttf';
					if( !JFile::exists($fontPath) )
					{
						igFileHelper::raiseError('Watermarking Font File Missing, Please Upload a file named font.ttf to : '.$fontPath , $refresh);
						return false;
					}
					else
					{
						$colorArray = explode(',', $wmTextColor); 
						$font = new GDImage_Font_TTF($fontPath, (int)$wmTextSize, $image->allocateColorAlpha((int)$colorArray[0], (int)$colorArray[1], (int)$colorArray[2], (100 - $wmTrans) ) );
						$canvas->setFont($font);
						$canvas->writeText($positionArray[0].$leftIndent, $positionArray[1].$topIndent, $wmText);
					}
					
    			}
    			
    			if( strlen($wmFilename) > 0)
    			{
	                if(!JFile::exists(IG_WATERMARK_PATH.'/'.$wmFilename))
                    {
                        igFileHelper::raiseError('Watermarking image missing, Please reupload the watermark image in the profile settings.', $refresh);
                        return false;
                    }
    			    $extWatermark = JFile::getExt(IG_WATERMARK_PATH.'/'.$wmFilename);
					$overlay = IGLImage::load(IG_WATERMARK_PATH.'/'.$wmFilename);
	                $image = $image->merge($overlay, $positionArray[0], $positionArray[1], $wmTrans);
    			}
    		}

    		if( preg_match("/jp/i", $destExt) || $destExt == 'webp')
    		{
    		    $image->saveToFile($destFile, $quality);
    		}
    		else
    		{
    		    $image->saveToFile($destFile);
    		}

            if($rotation != 0)
            {
                $image = IGLImage::load($destFile);
                $imageinfo = getimagesize($sourceFile);

                if($imageinfo[0] > $width || $imageinfo[1] > $height)
                {
                    if($crop == 1 && $imageinfo[0] > $width && $imageinfo[1] > $height)
                    {
                        $image = $image->resize( (int)$width ,(int)$height, 'outside' )->crop( 'center', 'middle', (int)$width, (int)$height );
                    }
                    else
                    {
                        $image = $image->resize( (int)$width, (int)$height, 'inside', 'down' );
                    }
                }

                $image->saveToFile($destFile);
            }

            return true;
		}
		return true;
	}

	static function raiseError($message, $refresh)
	{
	    if($refresh == true)
		{
            JFactory::getApplication()->enqueueMessage($message,'error');
		}
		else
		{
			echo $message;
		}
	}

    static function getExifRotation($filePath)
    {
        $rotation = 0;

        if( function_exists('exif_read_data') && preg_match("/jp/i", JFile::getExt($filePath)) )
        {
            $exifData = @exif_read_data($filePath);
            if(isset($exifData['Orientation']))
            {
                switch($exifData['Orientation'])
                {
                    case 3:
                        $rotation = 180;
                        break;
                    case 6:
                        $rotation = 90;
                        break;
                    case 8:
                        $rotation = -90;
                }
            }
        }

        return $rotation;
    }

    static function getSVGdimensions($filePath)
    {
        preg_match("#viewbox=[\"']\d* \d* (\d*+(\.?+\d*)) (\d*+(\.?+\d*))#i", file_get_contents($filePath), $d);
        return array((float)$d[1],(float)$d[3]);
    }

}