<?php

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Plugin\PluginHelper;

defined('_JEXEC') or die( 'Restricted access' );

class igalleryModelicategory extends igalleryModelBase
{
    public $galleryId;

	protected function canEditState($record)
	{
		if(JFactory::getApplication()->isClient('site') == true)
		{
			return true;
		}

		$user = JFactory::getUser();
		return $user->authorise('core.edit.state', $this->option);
	}

	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk))
		{
			if(empty($item->id))
			{
				$params = JComponentHelper::getParams('com_igallery');
				
				$item->published = $params->get('cat_published', 0);
				$item->set('parent',$params->get('default_parent', 0));
				$item->profile   = $params->get('default_profile', 0);
			}
			
			$item->remove_menu_image = 0;
		}
		
		return $item;
	}
	
	public function getForm($data = array(), $loadData = true)
	{
		JForm::addFieldPath(IG_ADMINISTRATOR_COMPONENT.'/models/fields');
		$form = $this->loadForm('com_igallery.category', IG_ADMINISTRATOR_COMPONENT.'/models/forms/category.xml', array('control' => 'jform', 'load_data' => $loadData));
		
		if( empty($form) )
		{
			return false;
		}
		
		return $form;
	}
	
	protected function loadFormData()
	{
		$data = $this->getItem();
		return $data;
	}
	
	public function getTable($type = 'igallery', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	function checkProfileExists()
	{
        $db	= $this->getDbo();
	    $query = 'SELECT id FROM #__igallery_profiles';
		$db->setQuery($query);
		$db->execute();
		$numRows = $db->getNumRows();
	    if($numRows == 0)
		{
		    return false;
		}
		
		return true;
	}
	
	protected function getReorderConditions($table = null)
	{
        return 'parent = '.(int)$table->parent;
	}
	
	function save($data)
	{
        $db	= $this->getDbo();
        $firstLast = 'last';
		$row = $this->getTable('igallery');
		$user = JFactory::getUser();
		$app = JFactory::getApplication();
        $input = $app->input;
		$params = JComponentHelper::getParams('com_igallery');
		$isSite =  JFactory::getApplication()->isClient('site');

        if(!empty($data['id']))
        {
            $query = 'SELECT * FROM #__igallery WHERE id = '.(int)$data['id'];
            $db->setQuery($query);
            $oldCategory = $db->loadObject();
        }
		
		if (!$row->bind($data)) 
		{
		    $this->setError($row->getError());
			return false;
		}

        $nullFields = array('publish_up','publish_down','second_user','third_user','fourth_user','extra_field_1','extra_field_2','extra_field_3','extra_field_4');
        $fieldsToReset = array();
		foreach($nullFields as $column)
        {
            if(empty($row->{$column}))
            {
                unset($row->{$column});
                $fieldsToReset[] = $column;
            }
        }

		if(empty($row->date))
        {
            unset($row->date);
        }

        $newRecord = empty($row->id);

		if(empty($row->id) ) 
		{
            $row->parent = empty($row->parent) ? $params->get('default_parent', 0) : $row->parent;
            $firstLast = $params->get('new_cat_ordering', 'last');
		    $row->ordering = $firstLast == 'first' ? 0 : $row->getNextOrder('parent = '.(int)$row->parent);
		    $row->profile = empty($row->profile) ? $params->get('default_profile', 1) : $row->profile;
		}

		if(empty($data['id']))
		{
			$row->moderate = $params->get('moderate_cat', 0) == 0 || $isSite == false ? 1 : 0;
		}

		$row->user = empty($row->user) ? $user->id : $row->user;
        $row->modified = date("Y-m-d H:i:s");

		if(JFactory::getConfig()->get('unicodeslugs') == 1)
        {
            $row->alias = empty($row->alias) ? JFilterOutput::stringURLUnicodeSlug($row->name) : JFilterOutput::stringURLUnicodeSlug($row->alias);
        }
        else
        {
            $row->alias = empty($row->alias) ? JFilterOutput::stringURLSafe($row->name) : JFilterOutput::stringURLSafe($row->alias);
        }

		$row->name = empty($row->name) ? '____' : $row->name;

		$raw = $input->get('jform', array(), 'RAW');
		$row->menu_description = JComponentHelper::filterText($raw['menu_description']);
		$row->gallery_description = JComponentHelper::filterText($raw['gallery_description']);

		if(!$row->store()) 
		{
			$this->setError( $row->getError() );
			return false;
		}

        foreach($fieldsToReset as $column)
        {
            $query = 'UPDATE #__igallery SET '.$column.' = NULL WHERE id = '.(int)$row->id;
            $db->setQuery($query);
            $db->execute();
        }


		$this->set('galleryId',$row->id);
		
		if(trim(str_replace('-','',$row->alias)) == '' )
		{
			$row->alias = 'category-'.(int)$row->id;
			if(!$row->store()) 
			{
				$this->setError( $row->getError() );
				return false;
			}
		}
		
		$query = 'SELECT alias from #__igallery where alias = "'.$db->escape($row->alias).'"';
		$db->setQuery($query);
        $rows = $db->loadObjectList();
        
        if( count($rows) > 1)
        {
        	$row->alias = $row->alias.'-'.(int)$row->id;
			if(!$row->store()) 
			{
				$this->setError( $row->getError() );
				return false;
			}
        }
		
		if($firstLast == 'first')
	    {
	       $row->reorder('parent = '.(int)$row->parent);
	    }

        JFactory::getApplication()->input->set('catid',$row->id);
		$folderName = igFileHelper::checkGalleryFolderExists($row->id);

        if(strlen($_FILES['jform']['name']['upload_image']) > 2 )
        {
            $fileName = $_FILES['jform']['name']['upload_image'];
            $tmpPath = $_FILES['jform']['tmp_name']['upload_image'];
            $uploadError = $_FILES['jform']['error']['upload_image'];

            if(!$fileArray = igFileHelper::processUploadedImage($fileName, $tmpPath, $uploadError, 'igallery', true) )
            {
                return false;
            }

            $row->menu_image_filename = $fileArray['filename'];
            $row->filesys = 1;
            if(!$row->store())
            {
                $this->setError( $row->getError() );
                return false;
            }

        }

        if($data['remove_menu_image'] == 1)
        {
            $query = 'SELECT menu_image_filename FROM #__igallery WHERE id = '.(int)$data['id'];
            $db->setQuery($query);
            $category = $db->loadObject();

            $query = 'SELECT menu_image_filename FROM #__igallery WHERE menu_image_filename = '.$this->_db->Quote($category->menu_image_filename);
            $db->setQuery($query);
            $db->execute();
            $numRows = $db->getNumRows();
            $deleteImg = $numRows > 1 ? false: true;

            if($deleteImg)
            {
                igFileHelper::deleteImage($category->menu_image_filename, $deleteImg, $folderName, $row->fileSys);
            }

            $row->menu_image_filename =  '';
            if(!$row->store())
            {
                $this->setError( $row->getError() );
                return false;
            }
        }

        if($oldCategory->name != $row->name)
        {
            //igFileHelper::checkGalleryFolderExists($row->id, true);
        }
	    
	    if($params->get('notify_new_category', 0) == 1 && $isSite == true && $newRecord)
	    {
	    	$siteConfig = JFactory::getConfig();
			$from = $siteConfig->get('mailfrom');
			$fromname = $siteConfig->get('fromname');
			$recipient = explode(',', $params->get('notify_emails', '') );
	    	$subject = $siteConfig->get('sitename').' : '.JText::_('NEW_CATEGORY_ADDED');
			
			$body   = 
			JText::_('JGLOBAL_USERNAME').': '.$user->name." \n\n ".
			JText::_('JCATEGORY').': '.$row->name." \n\n ".
			IG_HOST.'administrator/index.php?option=com_igallery&view=icategory&id='.$row->id." \n\n ".
			IG_HOST.'index.php?option=com_igallery&view=category&igid='.$row->id;

            $mail = JFactory::getMailer();

		    for($i=0; $i<count($recipient); $i++)
			{
                if(!filter_var($recipient[$i], FILTER_VALIDATE_EMAIL))
                {
                    JFactory::getApplication()->enqueueMessage('Please go to the ignite gallery options - moderation tab. Please enter a valid email address, or turn of the sending of emails.');
                    return false;
                }

                $mail->sendMail($from, $fromname, $recipient[$i], $subject, $body);
				if($i > 5){break;}
			}
	    }

        PluginHelper::importPlugin('content');
        $app->triggerEvent('onContentAfterSave', array('com_igallery.category', $row, true));
	    	
		return true;
	}
	
	function delete(&$pks)
	{
        $id = (int)$pks;
        $db	= $this->getDbo();
        $app = JFactory::getApplication();
		
		$query = 'SELECT * FROM #__igallery WHERE id = '.(int)$id;
        $db->setQuery($query);
        $category = $db->loadObject();

        $query = 'SELECT id FROM #__igallery WHERE parent = '.(int)$id;
        $db->setQuery($query);
        $children = $db->loadObjectList();
        if(count($children) > 0)
        {
            $this->setError('Error Gallery : "'.$category->name.'" has '.count($children).' child galleries. Please delete the children first');
            return false;
        }

        $rowPlugin = $this->getTable('igallery');
        $rowPlugin->load($id);
        
		if( strlen($category->menu_image_filename) > 2 )
        {
            $query = 'SELECT menu_image_filename FROM #__igallery WHERE menu_image_filename = '.$this->_db->Quote($category->menu_image_filename);
    		$db->setQuery($query);
    		$db->execute();
    		$numRows = $db->getNumRows();
    		$deleteOrig = $numRows > 1 ? false: true;
    		
            igFileHelper::deleteImage($category->menu_image_filename, $deleteOrig, $category->folder, $category->filesys);
        }
        
        $query = 'SELECT id, filename, filesys FROM #__igallery_img WHERE gallery_id = '.(int)$id;
        $db->setQuery($query);
        $photoList = $db->loadObjectList();
        
        for($i=0; $i<count($photoList); $i++)
		{
		    $photo = $photoList[$i];
		    
		    $query = 'SELECT filename FROM #__igallery_img WHERE filename = '.$db->Quote($photo->filename);
    		$db->setQuery($query);
    		$db->execute();
    		$numRows = $db->getNumRows();
    		$deleteOrig = $numRows > 1 ? false: true;
    		
    	    igFileHelper::deleteImage($photo->filename, $deleteOrig, $category->folder, $photo->filesys);
            
    		$query = 'DELETE FROM #__igallery_img WHERE id = '.(int)$photo->id;
    		$db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                return false;
            }
        }
	    
		$query = 'DELETE FROM #__igallery WHERE id = '.(int)$id;
		$db->setQuery($query);

        $db->setQuery($query);
        try
        {
            $db->execute();
        }
        catch(Exception $e)
        {
            JFactory::getApplication()->enqueueMessage( $e->getMessage() );
            return false;
        }

		$query = 'UPDATE #__igallery SET parent = 0 WHERE parent = '.(int)$id;
		$db->setQuery($query);
        try
        {
            $db->execute();
        }
        catch(Exception $e)
        {
            JFactory::getApplication()->enqueueMessage( $e->getMessage() );
            return false;
        }
		
		$row = $this->getTable('igallery');
    	$row->reorder('parent = '.(int)$category->parent);

        PluginHelper::importPlugin('content');
        $app->triggerEvent('onContentAfterDelete', array('com_igallery.category', $rowPlugin));

        if(!empty($category->folder) && strlen($category->folder) > 2)
        {
            $path = IG_ORIG_PATH.'/'.$category->folder;
            if(Jfolder::exists($path))
            {
                JFolder::delete($path);
            }
            $path = IG_RESIZE_PATH.'/'.$category->folder;
            if(Jfolder::exists($path))
            {
                JFolder::delete($path);
            }
        }

		
		return true;
	}
	
	function copy()
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
        $cid = $input->get('cid', array(0), 'INT');
		$id = (int)$cid[0];
		
	    $row = $this->getTable('igallery');
        $row->load($id);
        
        $row->id = null;
        $row->ordering = $row->getNextOrder('parent = '.(int)$row->parent);
        $row->name = JText::_('COPY_OF').' '.$row->name;
        $row->alias = JFilterOutput::stringURLSafe($row->name);
        $oldFolderName = $row->folder;
        $row->folder = '';
        
        if(!$row->store())
    	{
            JFactory::getApplication()->enqueueMessage($row->getError(), 'error');
    		return false;
    	}
    	
    	$catId = $db->insertid();

        $newFolderName = igFileHelper::checkGalleryFolderExists($catId);
    	
    	$query = 'SELECT * FROM #__igallery_img WHERE gallery_id = '.(int)$id;
		$photos = $this->_getList($query);
		
		$row = $this->getTable('igallery_img');
		
		for($i=0; $i<count($photos); $i++)
		{
		    $photo = $photos[$i];
		    
            $row->load($photo->id);
            $row->id = null;
            $row->gallery_id = $catId;
		   
            if(!$row->store())
            {
                JFactory::getApplication()->enqueueMessage($row->getError(), 'error');
                return false;
            }

            if($row->filesys == 1 && empty($row->src))
            {
                $sourcePath = IG_ORIG_PATH.'/'.$oldFolderName.'/'.$row->filename;
                $destPath = IG_ORIG_PATH.'/'.$newFolderName.'/'.$row->filename;
                if(!JFile::copy($sourcePath, $destPath))
                {
                    $this->setError($sourcePath.' -> '.$destPath .' '. 'Error Moving File To Directory');
                    return false;
                }
            }
		}
		
		return true;
	}
	
	function moderate($moderate)
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
        $cid = $input->get('cid', array(), 'INT');
		
		if (count($cid))
		{
			$cids = implode( ',', $cid );

			$query = 'UPDATE #__igallery SET moderate = '.(int)$moderate
			. ' WHERE id IN ( '.$cids.' )';
			$db->setQuery($query);
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                return false;
            }
		}

		return true;
	}

    function change_owner()
    {
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $newOwner = $input->get('change_owner_id',0,'INT');
        if(empty($newOwner))
        {
            $this->setError('No User Id Submitted');
            return false;
        }

        $cid = $input->get('cid', array(), 'INT');
        ArrayHelper::toInteger($cid);

        if(count($cid))
        {
            $cids = implode(',',$cid);

            $query = 'UPDATE #__igallery SET user = '.(int)$newOwner.' WHERE id IN ('.$cids.')';
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                $this->setError($e->getMessage());
                return false;
            }
        }

        return true;
    }

    function change_profile()
    {
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $newProfileId = $input->get('ig_change_profile',0,'INT');
        if(empty($newProfileId))
        {
            $this->setError('No Profile Id Submitted');
            return false;
        }

        $cid = $input->get('cid', array(), 'INT');
        ArrayHelper::toInteger($cid);

        if(count($cid))
        {
            $cids = implode(',',$cid);

            $query = 'UPDATE #__igallery SET profile = '.(int)$newProfileId.' WHERE id IN ('.$cids.')';
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                $this->setError($e->getMessage());
                return false;
            }
        }

        return true;
    }
	
}