<?php

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Plugin\PluginHelper;

defined('_JEXEC') or die( 'Restricted access' );

class igalleryModelimage extends igalleryModelBase
{
	protected function canEditState($record)
	{
		if(JFactory::getApplication()->isClient('site') == true)
		{
			return true;
		}

		$user = JFactory::getUser();
		return $user->authorise('core.edit.state', $this->option);
	}

	public function getItem($pk = null)
	{
		$item = parent::getItem($pk);
		return $item;
	}
    
	function getPhoto($id)
	{
        $db	= $this->getDbo();
		$query = 'SELECT * FROM #__igallery_img WHERE id = '. (int)$id;
		$db->setQuery($query);
		$photo = $db->loadObject();
		return $photo;
	}
	
	public function getForm($data = array(), $loadData = true)
	{
        $form = $this->loadForm('com_igallery.image', IG_ADMINISTRATOR_COMPONENT.'/models/forms/image.xml', array('control' => 'jform', 'load_data' => $loadData));
		if(empty($form))
        {
			return false;
		}
		
		return $form;
	}
	
	protected function loadFormData()
	{
		$data = $this->getItem();
		return $data;
	}
	
	public function getTable($type = 'igallery_img', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	protected function getReorderConditions($table = null)
	{
	    return 'gallery_id = '.(int)$table->gallery_id;
	}
	
	function store($fileData)
	{
	    $row = $this->getTable('igallery_img');
		$user = JFactory::getUser();
        $db	= $this->getDbo();
		$configArray = JComponentHelper::getParams('com_igallery');
		$app = JFactory::getApplication();
        $input = $app->input;
		$isSite =  JFactory::getApplication()->isClient('site');

		$row->id = null;
        $row->user = $user->id;
		$row->target_blank = $configArray->get('target_blank', 1);
		$row->access = $configArray->get('new_image_access', 1);
		$row->published = $configArray->get('new_image_published', 1);
		$row->gallery_id = $input->get('catid', 0, 'INT');
		$row->filename = $fileData['filename'];
		$row->moderate = $configArray->get('moderate_img', 0) == 0 || $isSite == false ? 1 : 0;
        $row->filesys = 1;

		$firstLast = $configArray->get('new_image_ordering', 'last');
		$row->ordering = $firstLast == 'first' ? 0 : $row->getNextOrder('gallery_id = '.$input->get('catid', 0, 'INT') );

        if( isset($fileData['filesrc']) )
        {
            $row->src = str_replace('\\', '/', $fileData['filesrc']);
        }

		if( isset($fileData['exif_des']) )
		{
			$row->description = strlen($fileData['exif_des']) > 0 ? $fileData['exif_des'] : $row->description;
		}
		
		if( isset($fileData['iptc_des']) )
		{
			$row->description = strlen($fileData['iptc_des']) > 0 ? $fileData['iptc_des'] : $row->description;
		}

		if( isset($fileData['iptc_tags']) )
		{
			if(strlen($fileData['iptc_tags']) > 0)
			{
				$row->tags = $fileData['iptc_tags'];
			}
		}

        if( isset($fileData['iptc_title']) )
        {
            $row->alt_text = $fileData['iptc_title'];
        }

		$row->exif_date = isset($fileData['exif_extra']['date']) ? strip_tags($fileData['exif_extra']['date']) : null;
		$row->exif_latitude = isset($fileData['exif_extra']['gps-latitude']) ? strip_tags($fileData['exif_extra']['gps-latitude']) : '';
		$row->exif_longitude = isset($fileData['exif_extra']['gps-longitude']) ? strip_tags($fileData['exif_extra']['gps-longitude']) : '';
		$row->exif_extra = isset($fileData['exif_extra']['extra']) ? strip_tags($fileData['exif_extra']['extra']) : '';

		if( isset($fileData['embed_code']) && (JFactory::getApplication()->isClient('site') == false || $configArray->get('allow_frontend_add_video', 0) == 1))
        {
            $row->embed_code = $fileData['embed_code'];
        }
			
        if( !$row->store() )
		{
		  	echo $row->getError();
		  	return false;
		}
		

		if($firstLast == 'first')
	    {
	       $row->reorder('gallery_id = '.(int)$row->gallery_id );
	    }
	    
	    $sessionValue = $app->getUserState('com_igallery.moderateimg'.$row->gallery_id, 0);

	    if( $isSite && empty($sessionValue) )
	    {
			if($configArray->get('notify_new_image', 0) == 1)
			{
				$siteConfig = JFactory::getConfig();
				$from = $siteConfig->get('mailfrom');
				$fromname = $siteConfig->get('fromname');
				$recipient = explode(',', $configArray->get('notify_emails', '') );
		    	$subject = $siteConfig->get('sitename').' : '.JText::_('NEW_IMAGES_ADDED');
				
				$body   = 
				JText::_('JGLOBAL_USERNAME').': '.$user->name." \n\n".
				IG_HOST.'administrator/index.php?option=com_igallery&view=images&catid='.$row->gallery_id." \n\n".
                JRoute::_(IG_HOST.'index.php?option=com_igallery&view=category&igid='.$row->gallery_id, false);

                for($i=0; $i<count($recipient); $i++)
				{
                    if(!filter_var($recipient[$i], FILTER_VALIDATE_EMAIL))
                    {
                        echo 'Please go to the ignite gallery options - moderation tab. Please enter a valid email address, or turn of the sending of emails.';
                        return false;
                    }

                    $mail = JFactory::getMailer();
                    $mail->sendMail($from, $fromname, $recipient[$i], $subject, $body);
					if($i > 12){break;}
				}
				
				$app->setUserState( 'com_igallery.moderateimg'.$row->gallery_id, 1);
			}
	    }

        $query = 'UPDATE #__igallery SET modified = '.$db->Quote(date("Y-m-d H:i:s")).' WHERE id = '.(int)$input->get('catid', 0,'INT');
        $db->setQuery($query);
        $db->execute();


        PluginHelper::importPlugin('content');
	    $app->triggerEvent('onContentAfterSave', array('com_igallery.image', $row, true));
	    
	    return true;
	}
	
	function delete(&$pks)
	{
        $app = JFactory::getApplication();
	    $input = $app->input;
	    $db	= $this->getDbo();
        ArrayHelper::toInteger($pks);

        $catId = JFactory::getApplication()->input->get('catid', 0,'INT');
        $folderName = igFileHelper::checkGalleryFolderExists($catId);
		
		for($i=0; $i<count($pks); $i++)
		{
            $rowPlugin = $this->getTable('igallery_img');
            $rowPlugin->load( (int)$pks[$i] );

		    $query = 'SELECT filename, filesys FROM #__igallery_img WHERE id = '.(int)$pks[$i];
            $db->setQuery($query);
            $photo = $db->loadObject();
            
		    $query = 'SELECT filename FROM #__igallery_img WHERE filename = '.$db->Quote($photo->filename);
    		$db->setQuery($query);
    		$db->execute();
    		$numRows = $db->getNumRows();
    		$deleteOrig = $numRows > 1 ? false: true;
    		
    	    igFileHelper::deleteImage($photo->filename, $deleteOrig, $folderName,$photo->filesys);

    		$query = 'DELETE FROM #__igallery_img WHERE id = '.(int)$pks[$i];
    		$db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                return false;
            }

            PluginHelper::importPlugin('content');
            $app->triggerEvent('onContentAfterDelete', array('com_igallery.image', $rowPlugin));

    	}
		
		$row = $this->getTable('igallery_img');
    	$row->reorder('gallery_id = '.$input->get('catid', 0, 'INT') );
		
		return true;
	}
	
	function copy_move()
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $currentCatId = JFactory::getApplication()->input->get('catid', 0,'INT');
        $row = $this->getTable('igallery');
        $row->load($currentCatId);
        $oldFolderName = $row->folder;

        $targetCatId = $input->get('cat_id_copy_move',0,'INT');
	    if($targetCatId == 0)
        {
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_NO_ITEMS_SELECTED'), 'error');
            return false; 
        }
	    $newFolderName = igFileHelper::checkGalleryFolderExists($targetCatId);
        
        $cid = $input->get('cid', array(), 'INT');
        $copyMove = $input->get('copy_move','copy','CMD');
        $row = $this->getTable('igallery_img');
        
        for($i=0; $i<count($cid); $i++)
		{
            $row->load( (int)$cid[$i]);
            $origId = $row->id;
            
            $row->id = null;
            $row->gallery_id = (int)$targetCatId;
            $row->ordering = $row->getNextOrder('gallery_id = '.(int)$targetCatId );
		   
            if(!$row->store())
            {
               $this->setError($row->getError());
               return false;
            }

            if($row->filesys == 1 && empty($row->src))
            {
                $sourcePath = IG_ORIG_PATH.'/'.$oldFolderName.'/'.$row->filename;
                $destPath = IG_ORIG_PATH.'/'.$newFolderName.'/'.$row->filename;
                if(!JFile::copy($sourcePath, $destPath))
                {
                    $this->setError($sourcePath.' -> '.$destPath .' '. 'Error Moving File To Directory');
                    return false;
                }
            }

            if($copyMove == 'move')
            {
                $query = 'DELETE FROM #__igallery_img WHERE id = '.(int)$origId;
        		$db->setQuery($query);
                try
                {
                    $db->execute();
                }
                catch(Exception $e)
                {
                    JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                    return false;
                }

                if($row->filesys == 1)
                {
                    igFileHelper::deleteImage($row->filename,true,$oldFolderName,$row->filesys);
                }
            }
		}
		return true;
	}

    function change_access()
    {
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $newAccess = $input->get('ig_change_access',1,'INT');

        $cid = $input->get('cid', array(), 'INT');
        ArrayHelper::toInteger($cid);

        if(count($cid))
        {
            $cids = implode(',',$cid);

            $query = 'UPDATE #__igallery_img SET access = '.(int)$newAccess.' WHERE id IN ('.$cids.')';
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                $this->setError($e->getMessage());
                return false;
            }
        }

        return true;
    }

    function change_owner()
    {
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $newOwner = $input->get('change_owner_id',0,'INT');
        if(empty($newOwner))
        {
            $this->setError('No User Id Submitted');
            return false;
        }

        $cid = $input->get('cid', array(), 'INT');
        ArrayHelper::toInteger($cid);

        if(count($cid))
        {
            $cids = implode(',',$cid);

            $query = 'UPDATE #__igallery_img SET user = '.(int)$newOwner.' WHERE id IN ('.$cids.')';
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                $this->setError($e->getMessage());
                return false;
            }
        }

        return true;
    }

    function change_link()
    {
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;

        $newLinkValue = $input->get('ig_change_link',1,'INT');

        $cid = $input->get('cid', array(), 'INT');
        ArrayHelper::toInteger($cid);

        if(count($cid))
        {
            $cids = implode(',',$cid);

            $query = 'UPDATE #__igallery_img SET target_blank = '.(int)$newLinkValue.' WHERE id IN ('.$cids.')';
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                $this->setError($e->getMessage());
                return false;
            }
        }

        return true;
    }
	
	function add_tags()
	{
        $input = JFactory::getApplication()->input;
	    $db	= $this->getDbo();
        $cid = $input->get('cid', array(), 'INT');
		
		$tagsToAdd = $input->get('add_tags','','STRING');
		
		if( substr($tagsToAdd, 0, 1) == ',')
		{
			$tagsToAdd = substr($tagsToAdd, 1);
		}
		
		if( substr($tagsToAdd, -1) == ',')
		{
			$tagsToAdd = substr($tagsToAdd, 0, -1);
		}

        $pattern = '/\s*,\s*/';
        $replace = ',';
        $tagsToAdd = preg_replace($pattern, $replace, $tagsToAdd);
		
		$row = $this->getTable('igallery_img');
        
        for($i=0; $i<count($cid); $i++)
		{
            $row->load( (int)$cid[$i] );

            $tagsArray = explode(',',$tagsToAdd);

            $currentTags = explode(',',$row->tags);
            foreach($tagsArray as $index => $tag)
            {
                if(in_array($tag,$currentTags))
                {
                    unset($tagsArray[$index]);
                }
            }

            $tagsStringNew = empty($tagsArray) ? '' : implode(',',$tagsArray);
            if(!empty($tagsStringNew))
            {
                $row->tags = empty($row->tags) ? $tagsStringNew : $row->tags.','.$tagsStringNew;
            }

            if(!$row->store())
            {
               $this->setError($row->getError());
               return false;
            }

		}
		return true;
	}
	
	function remove_tags()
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
        $cid = $input->get('cid', array(), 'INT');
		
		$tagsToRemove = $input->get('remove_tags', '','STRING');
		
		if( substr($tagsToRemove, 0, 1) == ',')
		{
			$tagsToRemove = substr($tagsToRemove, 1);
		}
		
		if( substr($tagsToRemove, -1) == ',')
		{
			$tagsToRemove = substr($tagsToRemove, 0, -1);
		}
		
		$tagsToRemoveArray = explode(',', $tagsToRemove );
		
		$row = $this->getTable('igallery_img');
        
        for($i=0; $i<count($cid); $i++)
		{
            $row->load( (int)$cid[$i] );
            
            $currentTagsArray = explode(',', $row->tags );
            
            for($r=0; $r<count($tagsToRemoveArray); $r++)
			{
				for($c=0; $c<count($currentTagsArray); $c++)
				{
					if($tagsToRemoveArray[$r] == $currentTagsArray[$c])
					{
						unset($currentTagsArray[$c]);
					}
				}
			}
			
			$row->tags = implode(',', $currentTagsArray);
            
            if(!$row->store())
            {
               $this->setError($row->getError());
               return false;
            }

		}
		return true;
	}
	
	function save($data)
	{


	    $input = JFactory::getApplication()->input;
	    $db	= $this->getDbo();
	    $row = $this->getTable('igallery_img');
	    
	    if (!$row->bind($data)) 
		{
			$this->setError($row->getError());
			return false;
		}

        $nullFields = array('publish_up','publish_down','extra_field_1','extra_field_2','extra_field_3','extra_field_4');
        $fieldsToReset = array();
        foreach($nullFields as $column)
        {
            if(empty($row->{$column}))
            {
                unset($row->{$column});
                $fieldsToReset[] = $column;
            }
        }

        if(empty($row->date))
        {
            unset($row->date);
        }
        unset($row->hits);

        if(strlen($_FILES['jform']['name']['upload_image']) > 2 )
        {
            $query = 'SELECT filename, filesys FROM #__igallery_img WHERE id = '.(int)$row->id;
            $db->setQuery($query);
            $oldPhoto = $db->loadObject();

            $query = 'SELECT filename FROM #__igallery_img WHERE filename = '.$db->Quote($oldPhoto->filename);
            $db->setQuery($query);
            $db->execute();
            $numRows = $db->getNumRows();
            $deleteOrig = $numRows > 1 ? false: true;

            $catId = $input->get('catid', 0,'INT');
            $folderName = igFileHelper::checkGalleryFolderExists($catId);

            igFileHelper::deleteImage($oldPhoto->filename, $deleteOrig,$folderName,$oldPhoto->filesys);

            $fileName = $_FILES['jform']['name']['upload_image'];
            $tmpPath = $_FILES['jform']['tmp_name']['upload_image'];
            $uploadError = $_FILES['jform']['error']['upload_image'];

            if(!$fileArray = igFileHelper::processUploadedImage($fileName, $tmpPath, $uploadError, 'igalleryImg', true, $row->id) )
            {
                return false;
            }

            $row->filename = $fileArray['filename'];
            $row->filesys = 1;
            $row->src = '';
        }
		
		if( strpos($row->description, 'class="des_div"') > 0 )
		{
            JFactory::getApplication()->enqueueMessage('Error: Html formatting has been copied from the gallery frontend into the description, please paste plain text', 'error');
        }

        $raw = $input->get('jform', array(), 'RAW');
		$row->description = JComponentHelper::filterText($raw['description']);
        $row->embed_code = JComponentHelper::filterText($raw['embed_code']);

        $pattern = '/\s*,\s*/';
        $replace = ',';
        $row->tags = preg_replace($pattern, $replace, $row->tags);

        $row->alt_text = str_replace('"', '', $row->alt_text);

        if (!$row->store())
		{
			$this->setError($row->getError());
			return false;
		}

        foreach($fieldsToReset as $column)
        {
            $query = 'UPDATE #__igallery_img SET '.$column.' = NULL WHERE id = '.(int)$row->id;
            $db->setQuery($query);
            $db->execute();
        }

        if( JFactory::getApplication()->isClient('site') )
        {
            $input->get('jform', array(), 'array');
            $id = (int)$data['id'];
        }
        else
        {
            $id = $input->get('id',0,'INT');
        }
		
		$query = 'SELECT gallery_id, ordering from #__igallery_img WHERE id = '.(int)$id;
    	$db->setQuery($query);
    	$currentRow = $db->loadObject();

		$nextOrdering = $currentRow->ordering + 1;
		$query = 'SELECT id from #__igallery_img WHERE gallery_id = '.(int)$currentRow->gallery_id.' AND ordering = '.(int)$nextOrdering.' LIMIT 1';
    	$db->setQuery($query);
    	$nextRow = $db->loadObject();

        $query = 'UPDATE #__igallery SET modified = '.$db->Quote(date("Y-m-d H:i:s")).' WHERE id = '.(int)$input->get('catid', 0,'INT');
        $db->setQuery($query);
        $db->execute();

		return $nextRow->id;
	}
	
	function rotate()
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
		$id = $input->get('id', 0,'INT');
		$rvalue = $input->get('rvalue', 0,'INT');
		
		$row = $this->getTable('igallery_img');
		$row->load( (int)$id );
		
		if($rvalue == 0)
		{
			$row->rotation = $row->rotation == 0 ? 270 : $row->rotation - 90;
		}
		else
		{
			$row->rotation = $row->rotation == 270 ? 0 : $row->rotation + 90;
		}
		
		if (!$row->store()) 
		{
			$this->setError($row->getError());
			return false;
		}
		
		return true;
	}
	
	function assignMenuImage()
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
		$id = $input->get('id', 0,'INT');
		$catid = $input->get('catid', 0,'INT');
		$cvalue = $input->get('cvalue', 0,'INT');
		
		$query = 'UPDATE #__igallery_img SET menu_image = 0 WHERE gallery_id = '.(int)$catid;
		$db->setQuery($query);
        try
        {
            $db->execute();
        }
        catch(Exception $e)
        {
            JFactory::getApplication()->enqueueMessage( $e->getMessage() );
            return false;
        }
    	
		$query = 'UPDATE #__igallery_img SET menu_image = '.(int)$cvalue.' WHERE id = '.(int)$id;
		$db->setQuery($query);
        try
        {
            $db->execute();
        }
        catch(Exception $e)
        {
            JFactory::getApplication()->enqueueMessage( $e->getMessage() );
            return false;
        }
		
    	return true;
	}
	
	function moderate($moderate)
	{
        $db	= $this->getDbo();
        $input = JFactory::getApplication()->input;
        $cid = $input->get('cid', array(), 'INT');
		
		if (count($cid))
		{
			$cids = implode( ',', $cid );

			$query = 'UPDATE #__igallery_img SET moderate = '.(int)$moderate
			. ' WHERE id IN ( '.$cids.' )';
			$db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                JFactory::getApplication()->enqueueMessage( $e->getMessage() );
                return false;
            }
		}

		return true;
	}
		
}