<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;

if(!IG_J4){
    JHtml::_('bootstrap.tooltip');
    JHtml::_('behavior.multiselect');
    JHtml::_('formbehavior.chosen', 'select');
}else{
    JHtml::_('jquery.framework');
}

$saveOrderingUrl = 'index.php?option=com_igallery&task=categories.saveOrderAjax&tmpl=component';
if(IG_J4)
{
    HTMLHelper::_('draggablelist.draggable');
}
else
{
    JHtml::_('sortablelist.sortable', 'categoryList', 'adminForm', 'asc', $saveOrderingUrl);
}
?>

<style type="text/css">
td.order input{
width: 40px !important;
}

#new-version-info{
     border:1px solid #ccc;
     border-radius:3px;
     margin-right:10px;
     float:right;
 }

#categoryList a{
    text-decoration: none!important;
}

.ig-ordering-th button{
    padding:0px!important;
}
<?php if(IG_J4): ?>
.ig-change-user-tr button{
    background-color: var(--template-bg-dark-60)!important;
<?php else: ?>
#ig-category-actions-bottom .ig-submit{position:relative;top:-4px;}
<?php endif; ?>
</style>

<script>
jQuery(document).ready(function($)
{
    var groups = [];
    var firstOrderNumbers = [];
    $('#categoryList').find('tbody tr').each(function(index,el)
    {
        var groupId =  $(el).attr('sortable-group-id');
        var orderNumber =  $(el).find('.ig-orderbox').val();
        if(groups.indexOf(groupId) == -1)
        {
            groups.push(groupId);
            firstOrderNumbers.push(orderNumber);
        }
    });

    $('.ig-order-cell').mouseup(function()
    {
        setTimeout(function()
        {
            $.each(groups, function(index, value )
            {
                var orderNumber = firstOrderNumbers[index];
                $('#categoryList').find("tbody tr[sortable-group-id='" + value + "']").each(function(index,el)
                {
                    $(el).find('.ig-orderbox').val(orderNumber);
                    orderNumber++;
                });
            });

        }, 1000);
    });
});
</script>

<form action="<?php echo JRoute::_('index.php?option=com_igallery&view=categories'); ?>" method="post" name="adminForm" id="adminForm">

<?php if (!empty($this->sidebar) && IG_J4 == false) : ?>
<div id="j-sidebar-container" class="span2">
    <?php echo $this->sidebar; ?>
</div>
<div id="j-main-container" class="span10">
<?php else : ?>
<div id="j-main-container">
<?php endif; ?>

<fieldset id="filter-bar" <?php if(IG_J4): ?>style="margin-bottom:8px;"<?php endif; ?>>

    <?php if(IG_J4): ?>
    <div class="btn-group">
        <div class="input-group">
            <input type="text" name="filter_search" id="filter_search" value="<?php echo $this->state->get('filter.search'); ?>" class="form-control" placeholder="Search" inputmode="search"  >
            <button type="submit" class="btn btn-primary" aria-label="Search"><span class="icon-search" aria-hidden="true"></span></button>
            <button type="button" class="btn btn-primary" onclick="document.getElementById('filter_search').value='';this.form.submit();"><span class="icon-times" aria-hidden="true"></span></button>
        </div>
    </div>

    <?php else: ?>
	<div class="filter-search btn-group pull-left" style="float:left">
		<label class="filter-search-lbl element-invisible" for="filter_search" style="float: left;"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
		<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->state->get('filter.search'); ?>" />
		</div><div class="btn-group pull-left" style="float:left">
		<button type="submit" class="btn hasTooltip"><i class="icon-search"></i></button>
		<button type="button" class="btn hasTooltip" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
    </div>
    <?php endif; ?>

	<div class="filter-select fltrt pull-right" style="float:right">
		<select name="filter_published" class="inputbox form-select" onchange="this.form.submit()">
			<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
			<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions',array('archived'=>0,'trash'=>0,'all'=>0)), 'value', 'text', $this->state->get('filter.published'), true);?>
		</select>
	</div>

	<div class="btn-group pull-right" style="float:right">
        <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
        <?php echo $this->pagination->getLimitBox(); ?>
    </div>



<?php
$newVersion = false;
$doCheck = false;

if($this->params->get('show_new_version',1) == 1)
{
    $versionFromSession = $this->app->getUserState('com_igallery.latestversion', 'unset');

    if($versionFromSession == 'unset')
    {
        $doCheck = true;
    }
    else
    {
        if(floatval($versionFromSession) > floatval(IG_VERSION))
        {
            $newVersion = true;
        }
    }
}

$style = $newVersion ? 'display:block;' : 'display:none;';
$style .= IG_J4 ? 'margin-top:1px;padding:7px;' : 'height:18px;padding:4px 12px;';
?>
<div id="new-version-info" style="<?php echo $style; ?>" class="filter-select">
    <a id="new-version-link" href="https://www.ignitegallery.com/documentation/changelog" target="_blank">A New Version is Available</a>
</div>

</fieldset>
<div style="clear:both; height: 0px; overflow: hidden;"> </div>

<table class="adminlist table table-striped" id="categoryList">
	<thead>
		<tr>

            <th width="1%" class="nowrap center hidden-phone">
                <?php echo JHtml::_('grid.sort', '<span class="icon-menu-2"></span>', 'ordering', 'asc', 'ordering', null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
            </th>

			
			<th width="20">
				<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
			</th>
			
			<th>
				<?php echo JText::_('JGLOBAL_TITLE'); ?>
			</th>
			
			<th>
				<?php echo JText::_( 'MANAGE_IMAGES' ); ?>
			</th>
			
			<th>
				<?php echo JText::_('JAUTHOR' ); ?>
			</th>
			
			<th>
				<?php echo JText::_('PROFILE'); ?>
			</th>
			
			<th width="5%">
				<?php echo JText::_('JPUBLISHED'); ?>
			</th>
			
			<?php if( !empty($this->moderate) ): ?>
			<th width="5%">
				<?php echo JText::_( 'APPROVED' ); ?>
			</th>
			<?php endif; ?>

            <th style="width:120px;" class="ig-ordering-th">
                <?php echo JText::_('JGRID_HEADING_ORDERING'); ?>

                <a href="#" class="hasPopover" data-content="Save Ordering" data-placement="top">
                <button onclick="jQuery('#categoryList td input:checkbox').prop('checked', true);Joomla.submitbutton('categories.saveorder');" class="btn btn-micro pull-right">
                    <?php if(IG_J4): ?>
                    <span class="icon-save"></span>
                    <?php else: ?>
                        <span class="icon-apply"></span>
                    <?php endif; ?>
                </button>
                </a>

            </th>


			<th width="1%" class="nowrap">
                <?php echo JText::_('JGRID_HEADING_ID'); ?>
			</th>

		</tr>
	</thead>

<?php $footerColumns = empty($this->moderate) ? 9 : 10; ?>
	<tfoot>
		<tr>
			<td colspan="<?php echo $footerColumns; ?>">
			<?php if($this->isSite == false): ?>
				<?php echo $this->pagination->getListFooter(); ?>
			<?php endif; ?>
			</td>
		</tr>
	</tfoot>

    <?php if(IG_J4): ?>
    <tbody class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="asc" data-nested="true">
    <?php else: ?>
    <tbody>
    <?php endif; ?>

    <?php

	foreach($this->items as $i => $item):
		
		$editOk = igGeneralHelper::authorise('core.edit', $item->id, null, $item->profile, $item->user);
		$editStateOk = igGeneralHelper::authorise('core.edit.state', $item->id, null, $item->profile, $item->user);
        $parents = igTreeHelper::getParentPath(igStaticHelper::getCategories(), $item->id, false);
        $parentsStr = '';
        foreach($parents as $parent)
        {
            $parentsStr .= ' '.$parent->id;
        }
        ?>
		<tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->parent; ?>" data-draggable-group="<?php echo $item->parent; ?>" item-id="<?php echo $item->id ?>" parents="<?php echo $parentsStr ?>" level="<?php echo $item->level; ?>">


            <?php if(!IG_J4): ?>
            <td class="ig-order-cell order nowrap center hidden-phone">
                <?php
                $iconClass = '';
                if (!$editStateOk)
                {
                    $iconClass = ' inactive';
                }
                ?>
                <span class="sortable-handler<?php echo $iconClass ?>">
                            <span class="icon-menu"></span>
                        </span>
                <?php if ($editStateOk) : ?>
                    <input type="text" style="display:none" name="order[]" size="5"
                           value="<?php echo $item->ordering; ?>" class="width-20 text-area-order ig-ajax-order" />
                <?php endif; ?>
            </td>
            </td>
            <?php else: ?>
            <td class="text-center d-none d-md-table-cell">
                <?php
                $iconClass = '';
                if (!$editStateOk)
                {
                    $iconClass = ' inactive';
                }
                ?>
                <span class="sortable-handler<?php echo $iconClass; ?>">
                                    <span class="icon-ellipsis-v" aria-hidden="true"></span>
                                </span>
                <?php if ($editStateOk) : ?>
                    <input type="text" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order hidden">
                <?php endif; ?>
            </td>
            <?php endif; ?>

            <td class="center">
				<?php echo JHtml::_('grid.id', $i, $item->id); ?>
			</td>
			
			<td>
				<?php if($editOk): ?>
				<a href="<?php echo JRoute::_('index.php?option=com_igallery&view=icategory&id='.$item->id, false); ?>">
				<?php endif; ?>
				
                <?php $item->name = strlen($item->name) < 1 ? '____' : $item->name ?>
                <?php for($k=0;$k<$item->level;$k++){echo '.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';}if($item->level>0){echo'<sup>|_</sup>&nbsp;';}echo $this->escape($item->name); ?>
				
				<?php if($editOk): ?>
				</a>
				<?php endif; ?>
			</td>
			
			<td>
			<?php if($editOk): ?>
				<a href="<?php echo JRoute::_('index.php?option=com_igallery&view=images&catid='.$item->id, false); ?>">
			<?php endif; ?>
					<?php echo JText::_( 'MANAGE_IMAGES' ); ?> (<?php echo $item->numimages; ?>)
			<?php if($editOk): ?>
				</a>
			<?php endif; ?>
			</td>
			
			<td>
				<?php echo empty($item->name_of_user) ? 'Error: No User With Id: '.$item->user.' Found' : $item->name_of_user; ?>
			</td>
			
			<td>
			<?php if($this->canConfigure && $this->isSite == false): ?>
				<a href="index.php?option=com_igallery&view=profile&id=<?php echo $item->profile; ?>">
			<?php endif; ?>
			
			<?php echo $item->profile_name; ?>
			
			<?php if($this->canConfigure && $this->isSite == false): ?>
				</a>
			<?php endif; ?>
			
			</td>
			
			<td>
				<?php echo JHtml::_('jgrid.published', $item->published, $i, 'categories.', $editStateOk, 'cb', $item->publish_up, $item->publish_down);?>
			</td>
			
			<?php if( !empty($this->moderate) ): ?>
			<td align="center">
				<?php echo igHtmlHelper::moderateImage($item, $i, 'categories', $this->isSite); ?>
			</td>	
			<?php endif; ?>


            <td class="order nowrap" style="width:120px;">
                <input type="text" name="orderbox[]" size="5" value="<?php echo $item->ordering;?>" class="text-area-order ig-orderbox" />
            </td>

			
			<?php if($this->isSite == false): ?>
			<td class="center">
				<?php echo $item->id; ?>
			</td>
			<?php endif; ?>
			
		</tr>
		<?php endforeach; ?>
</tbody>
</table>

<div id="ig-bottom-actions-wrapper" style="display:none;">
<table id="ig-category-actions-bottom" style="margin-top:25px;margin-left:10px;">
    <?php
    $db = JFactory::getDBO();
    $query = "SELECT id as value, name as text FROM #__igallery_profiles WHERE published = 1 ORDER BY ordering";
    $db->setQuery($query);
    $profiles = $db->loadObjectList();
    $selectHTML = JHTML::_("select.genericlist", $profiles, 'ig_change_profile', 'class="inputbox form-select"');
    ?>

    <tr>
        <td><?php echo JText::_('CHANGE_PROFILE_SELECTED_CATEGORIES'); ?>:&nbsp;&nbsp;</td>
        <td><?php echo $selectHTML; ?> </td>
        <td><a href="#" onclick="Joomla.submitbutton('categories.change_profile')"><input type="button" class="btn btn-primary ig-submit" name="change_profile_button" value="<?php echo JText::_('JSUBMIT'); ?>" /></a></td>
    </tr>

    <?php
    $data = '
            <?xml version="1.0" encoding="utf-8"?>
            <form><fieldset>
            <field name="change_owner_id" type="user" label="JGLOBAL_FIELD_CREATED_BY_LABEL" />
            </fieldset></form>';
    $userForm = JForm::getInstance('ig_users',$data);
    ?>

    <tr class="ig-change-user-tr">
        <td><?php echo JText::_('CHANGE_OWNER_SELECTED_CATEGORIES'); ?>:&nbsp;&nbsp;</td>
        <td><?php echo $userForm->getInput('change_owner_id'); ?> </td>
        <td><a href="#" onclick="Joomla.submitbutton('categories.change_owner')"><input type="button" class="btn btn-primary ig-submit" name="change_user_button" value="<?php echo JText::_('JSUBMIT'); ?>" /></a></td>
    </tr>
</table>
</div>

<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
<input type="hidden" name="filter_order" value="ordering" />
<input type="hidden" name="filter_order_Dir" value="asc" />
<?php echo JHtml::_('form.token'); ?>

<div class="modal fade" id="ig-image-modal" tabindex="-1" style="display:none;">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">

            <?php if(!IG_J4): ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div style="clear:both;"></div>
            <?php endif; ?>

            <div class="modal-body" id="ig-image-modal-content" style="margin:auto;padding-bottom:40px;"></div>

            <?php if(IG_J4): ?>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

</div>
</form>



<?php if($doCheck): ?>
<script>
function return_version(versionNumber)
{
    var currentVersion = parseFloat(<?php echo IG_VERSION; ?>);
    var latestVersion = parseFloat(versionNumber);

    if(latestVersion > currentVersion)
    {
        var elem = document.querySelector('#new-version-info');
        elem.style.display = 'block';
    }

    var url = '<?php echo JURI::root(true); ?>' + '/administrator/index.php?option=com_igallery&format=raw&task=categories.setVersionSession&version=' + versionNumber;
    var xhttp = new XMLHttpRequest();
    xhttp.open('GET', url, true);
    xhttp.send();
}

jQuery(document).ready(function($)
{
    $.ajax({
        url: "https://www.ignitegallery.com/update/latest-version-number.php",
        jsonp: "return_version",
        dataType: "jsonp"
    });
});
</script>
<?php endif; ?>

<script>
jQuery(document).ready(function($)
{
    $('#toolbar-ellipsis-h button').first().prop('onclick', null);
    $('#toolbar-menu button').first().prop('onclick', null);

    $('#toolbar-ellipsis-h button').first().on('click', function(e)
    {
        e.preventDefault();
        $('#ig-image-modal-content').append($('#ig-category-actions-bottom'));
        var myModal = new bootstrap.Modal(document.getElementById('ig-image-modal'));
        myModal.show();
    });

    $('#toolbar-menu button').first().on('click', function(e)
    {
        e.preventDefault();
        $('#ig-image-modal-content').append($('#ig-category-actions-bottom'));
        $('#ig-image-modal-content').css('max-width',$(this).attr('data-width')+'px');
        $('#ig-image-modal').modal();
    });
});
</script>



