<?php
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class igalleryViewImages extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null)
	{

	    $this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->isSite = JFactory::getApplication()->isClient('site');
		$this->user         = JFactory::getUser();
        $input = JFactory::getApplication()->input;
		
		$model              = $this->getModel();
		$this->category		= $model->getCategory( $input->get('catid', 0,'INT') );
		

		if (count($errors = $this->get('Errors'))) 
		{
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->params = JComponentHelper::getParams('com_igallery');
		$this->moderate = $this->params->get('moderate_img', 0);
		
		$this->catDropDown = igHtmlHelper::getCategorySelect('catid', 'id', 'name', null, true, 1, true, $this->category->id);
		
		if( !empty($this->category->id) )
		{
			$selectItems     = array();
		    $selectItems[]   = JHTML::_('select.option', 'copy', JText::_('IG_COPY') );
		    $selectItems[]   = JHTML::_('select.option', 'move', JText::_('IG_MOVE') );
		    $this->copyMove = JHTML::_('select.genericlist', $selectItems, 'copy_move', 'class="inputbox form-select" size="1"' );
		    
		    $this->catCopyMove = igHtmlHelper::getCategorySelect('cat_id_copy_move', 'id', 'name', $this->category->id, true, 1, false, 0);
		}
	    
	    $this->thumbFiles = array();
	    $this->mainFiles = array();

	    for ($i=0; $i<count($this->items); $i++)
		{
		    $row = $this->items[$i];

            $folderName = $row->filesys == 1 ? $row->folder : '';
		    
		    if(! $this->thumbFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $row->thumb_width,
		    $row->thumb_height, $row->img_quality, $row->crop_thumbs, $row->rotation,
		    $row->round_thumb, $row->round_fill,$row->crop_position) )
		    {
                $this->thumbFiles[$i] = array();
		    }
		    
		    if(! $this->mainFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $row->max_width,
		    $row->max_height, $row->img_quality, $row->crop_main, $row->rotation, $row->round_large, $row->round_fill,
            $row->crop_position, $row->watermark, $row->watermark_text, $row->watermark_text_color, $row->watermark_text_size,
		    $row->watermark_filename, $row->watermark_position, $row->watermark_transparency) )
		    {
                $this->mainFiles[$i] = array();
		    }	
		}

        $this->showImportServer = false;
        if( $this->params->get('show_import_server', 0) && $this->category->id > 0 && $this->isSite == false && igGeneralHelper::authorise('core.create', $this->category->id) )
        {
            $this->showImportServer = true;
        }

        if( $this->showImportServer )
        {
            $data = '
            <?xml version="1.0" encoding="utf-8"?>
            <form><fieldset>
            <field name="server_import" type="ifolderlist" directory="images" label="SERVER_IMPORT"  addfieldpath="administrator/components/com_igallery/models/fields"/>
            </fieldset></form>';
            $this->imagesForm = JForm::getInstance('images',$data);
        }

        if( $this->params->get('import_exif_data', 0) == 1 && !function_exists('exif_read_data'))
        {
            JFactory::getApplication()->enqueueMessage('Warning, importing of exif descriptions has been enabled in the component options - upload tab, but the php extension exif has not been enabled in php.ini, no exif data will be imported.');
        }

        if(JFactory::getSession()->get('ig_uploaded', 0) == 1)
        {
            JFactory::getApplication()->enqueueMessage(JText::_('NEW_IMAGES_ADDED'));
            JFactory::getSession()->set( 'ig_uploaded', 0);
        }
		
		$this->addToolbar($this->category);
		igHtmlHelper::addSubmenu();
        $this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
		
	}
	
	protected function addToolbar($category)
	{
        $input = JFactory::getApplication()->input;

	    JToolBarHelper::title( JText::_( 'MANAGE_IMAGES').' - <a class="ig-category-link" href="index.php?option=com_igallery&view=icategory&id='.$category->id.'">'.$category->name.'</a>' ,'generic.png' );
		
		if($this->isSite == true)
		{
			JToolBarHelper::back('JTOOLBAR_BACK','index.php?option=com_igallery&view=categories&Itemid='.$input->get('Itemid', '','INT') );
		}
		
		if(igGeneralHelper::authorise('core.edit.state')) 
		{
			JToolBarHelper::custom('images.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			JToolBarHelper::custom('images.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
		}
		
		if($this->moderate == 1  && $this->isSite == false)
		{
			JToolBarHelper::custom('images.moderate', 'checkin.png', 'checkin_f2.png', JText::_( 'APPROVE' ) );
			JToolBarHelper::custom('images.unmoderate', 'remove.png', 'remove_f2.png', JText::_( 'UNAPPROVE' ) );
		}
		
		if(igGeneralHelper::authorise('core.delete')) 
		{
			JToolBarHelper::deleteList(JText::_( 'CONFIRM_DELETE_CATEGORY' ), 'images.delete','JTOOLBAR_DELETE');
		}

        if(!IG_J4)
        {
            JToolBarHelper::custom('', 'menu', '', JText::_( 'IG_MORE_ACTIONS' ) );
        }
        else
        {
            JToolBarHelper::custom('', 'ellipsis-h', '', JText::_( 'IG_MORE_ACTIONS' ) );
        }

		if(igGeneralHelper::authorise('core.admin') && $this->isSite == false)
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_igallery');
		}
		
	}
}