<?php
defined('_JEXEC') or die('Restricted access');

if(IG_J4){JHtml::_('jquery.framework');}

$db	= JFactory::getDBO();
$query = 'SELECT * FROM #__igallery_img WHERE filesys = 0';
$db->setQuery($query);
$images = $db->loadObjectList();

$db	= JFactory::getDBO();
$query = "SELECT * FROM #__igallery WHERE filesys = 0 AND TRIM(menu_image_filename) <> ''";
$db->setQuery($query);
$menuImages = $db->loadObjectList();

require_once(IG_ADMINISTRATOR_COMPONENT.'/controllers/migrate.raw.php');
$migrateController = new igalleryControllerMigrate();
$folderCount = $migrateController->migrate_delete(true,false);


if(count($images) == 0 && count($menuImages) == 0 && $folderCount==0)
{
    ?><p class="ig-info">All Images Have Been Migrated</p><?php
}
else
{
?>
<p style="font-size:18px;">*<?php echo count($images); ?> Gallery Images have not been migrated.</p>
<p style="font-size:18px;">*<?php echo count($menuImages); ?> Menu Images have not been migrated.</p>
<p style="font-size:18px;">*<?php echo $folderCount; ?> Folders have not been deleted.</p>
<br /><hr /><br />
<p style="font-size:18px;">Step 1: Please backup the images/igallery/original folder. To make a backup quickly, zip the folder:</p>
<p><img src="https://www.ignitegallery.com/images/common-questions/migrate-backup-1.jpg" /></p>
<br /><hr /><br />
<p style="font-size:18px;">Step 2: Database table backup. Please go to your webhosting control panel, choose phpmyadmin, select your websites database, and export the igallery and igallery_img table.</p>
<p><img src="https://www.ignitegallery.com/images/common-questions/migrate-backup-2.jpg" /></p>
<br /><hr /><br />
<p style="font-size:18px;">**If you have an error during migration, it is likely the gallery will still work. Please copy the error and email ignite gallery support. If possible please send a temp admin login.
If you need to restore the backup, please restore the images/igallery/original folder that was zipped in step 1. Also please restore the 2 database tables.
To restore the database tables, delete the igallery and igallery_img tables, and import the backups (using phpmyadmin).</p>

<br /><hr /><br />

<p style="font-size:18px;">***After migration, the first view of the gallery in the website frontend will be a little slow. This is because the resized images are being generated.
 This will only happen the first time a gallery is viewed.</p>
<div><button class="btn btn-success" id="ig-start-migration">Start Migration</button></div>

<div id="ig-migrate-meta" data-total="<?php echo count($images); ?>" data-menu-total="<?php echo count($menuImages); ?>"></div>
<div id="ig-progress"></div>

<script>
jQuery(document).ready(function($)
{
    var totalImages = $('#ig-migrate-meta').attr('data-total');
    var totalMenuImages = $('#ig-migrate-meta').attr('data-menu-total');
    var start = 0;
    var menuStart = 0;
    var folderStart = 0;

    function igDoRequestImage()
    {
        if(totalImages > 0)
        {
            $('#ig-progress').append('<p class="ig-info">Migrating images '+start+'-'+(start+100)+' / '+totalImages+'</p>');

            var serverUrl = 'index.php?option=com_igallery&task=migrate.migrate&format=raw&start='+start;

            $.ajax
            ({
                url: serverUrl,
                error: function(response)
                {
                    console.log(response);
                    responseText =  jQuery(response.responseText).text().replace(/\s+/g, " ").trim();

                    $('#ig-progress').append('<p class="ig-error">Http Error, response from server: ' + responseText +'</p>')
                },
                success: function(response)
                {
                    console.log(response);
                    if(response.trim() != 1)
                    {
                        responseText =  jQuery('<p>'+response+'</p>').text().replace(/\s+/g, " ").trim();
                        $('#ig-progress').append('<p class="ig-error">Error, response from server: ' + responseText+'</p>');
                        return;
                    }

                    if( (start+100) < totalImages)
                    {
                        start = start+100;
                        igDoRequestImage();
                    }
                    else
                    {
                        $('#ig-progress').append('<p class="ig-info">Step 1 of 3 complete, Gallery Images have been migrated'+'</p>');
                        igDoRequestMenuImage();
                    }

                }
            });
        }
        else
        {
            $('#ig-progress').append('<p class="ig-info">No Gallery Images to Migrate</p>');
            igDoRequestMenuImage();
        }

    }

    function igDoRequestMenuImage()
    {
        if(totalMenuImages > 0)
        {
            $('#ig-progress').append('<p class="ig-info">Migrating menu images '+menuStart+'-'+(menuStart+100)+' / '+totalMenuImages+'</p>');

            var serverUrl = 'index.php?option=com_igallery&task=migrate.migrate_menu&format=raw&start='+menuStart;

            $.ajax
            ({
                url: serverUrl,
                error: function(response)
                {
                    console.log(response);
                    responseText =  jQuery(response.responseText).text().replace(/\s+/g, " ").trim();

                    $('#ig-progress').append('<p class="ig-error">Http Error, response from server: ' + responseText +'</p>')
                },
                success: function(response)
                {
                    console.log(response);
                    if(response.trim() != 1)
                    {
                        responseText =  jQuery('<p>'+response+'</p>').text().replace(/\s+/g, " ").trim();
                        $('#ig-progress').append('<p class="ig-error">Error, response from server: ' + responseText+'</p>');
                        return;
                    }

                    if( (menuStart+100) < totalMenuImages)
                    {
                        menuStart = menuStart+100;
                        igDoRequestMenuImage();
                    }
                    else
                    {
                        $('#ig-progress').append('<p class="ig-info">Step 2 of 3 complete, Menu Images have been migrated'+'</p>');
                        igDoRequestFolderCount();
                    }

                }
            });
        }
        else
        {
            $('#ig-progress').append('<p class="ig-info">No Menu Images to Migrate</p>');
            igDoRequestFolderCount();
        }

    }

    function igDoRequestFolderCount()
    {
        $('#ig-progress').append('<p class="ig-info">Counting folders to delete...</p>');

        var serverUrl = 'index.php?option=com_igallery&task=migrate.migrate_delete_count&format=raw';

        $.ajax
        ({
            url: serverUrl,
            error: function(response)
            {
                console.log(response);
                responseText =  jQuery(response.responseText).text().replace(/\s+/g, " ").trim();

                $('#ig-progress').append('<p class="ig-error">Http Error, response from server: ' + responseText +'</p>')
            },
            success: function(response)
            {
                console.log(response);
                response = response.trim();
                if(!igIsNumeric(response))
                {
                    responseText =  jQuery('<p>'+response+'</p>').text().replace(/\s+/g, " ").trim();
                    $('#ig-progress').append('<p class="ig-error">Error Counting Folders, response from server: ' + responseText+'</p>');
                    return;
                }
                else
                {
                    $('#ig-progress').append('<p class="ig-info">Number of Folders to Delete:'+response+'</p>');
                    igDoRequestFolder(response);
                }

            }
        });

    }

    function igDoRequestFolder(folderTotal)
    {
        $('#ig-progress').append('<p class="ig-info">Deleting Folders '+folderStart+'-'+(folderStart+100)+' / '+folderTotal+'</p>');

        var serverUrl = 'index.php?option=com_igallery&task=migrate.migrate_delete&format=raw&start='+folderStart;

        $.ajax
        ({
            url: serverUrl,
            error: function(response)
            {
                console.log(response);
                responseText =  jQuery(response.responseText).text().replace(/\s+/g, " ").trim();

                $('#ig-progress').append('<p class="ig-error">Http Error, response from server: ' + responseText +'</p>')
            },
            success: function(response)
            {
                console.log(response);
                if(response.trim() != 1)
                {
                    responseText =  jQuery('<p>'+response+'</p>').text().replace(/\s+/g, " ").trim();
                    $('#ig-progress').append('<p class="ig-error">Error, response from server: ' + responseText+'</p>');
                    return;
                }

                if( (folderStart+100) < folderTotal)
                {
                    folderStart = folderStart+100;
                    igDoRequestFolder(folderTotal)
                }
                else
                {
                    $('#ig-progress').append('<p class="ig-info">Step 3 of 3 complete, Folders have been deleted'+'</p>');
                    $('#ig-progress').append('<p class="ig-info"><b>Migration Completed Successfully'+'<b></p>');
                }

            }
        });

    }

    function igIsNumeric(value)
    {
        return /^-?\d+$/.test(value);
    }

    $('#ig-start-migration').on('click', function(e)
    {
        $('#ig-progress').append('<p class="ig-info">Starting Migrating...</p>');
        igDoRequestImage();
    });

});
</script>
<style>
.ig-info{
    background-color:#ccffcc;
    margin: 3px 0px;
    border: 1px solid #ccc;
    padding:5px;
    border-radius: 3px;
}
.ig-error{
    background-color:#ff6666;
    margin: 3px 0px;
    border: 1px solid #ccc;
    padding:5px;
    border-radius: 3px;
}

#ig-progress{
    margin-top:5px;
}
</style>
<br /><br />
<?php
}

?>

