<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class igalleryControllerimages extends JControllerAdmin
{
	public function &getModel($name = 'Image', $prefix = 'IgalleryModel', $config=array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	function browserUpload()
	{
		if(!igGeneralHelper::authorise('core.igalleryfront.upload', $this->input->get('catid',0,'INT') ) )
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
            return false;
		}
		
		for($i=0; $i<count($_FILES['uploads']['name']); $i++)
		{
			$fileName = $_FILES['uploads']['name'][$i];
			$tmpPath = $_FILES['uploads']['tmp_name'][$i];
			$uploadError = $_FILES['uploads']['error'][$i];
			
			if(! $fileData = igFileHelper::processUploadedImage($fileName, $tmpPath, $uploadError, 'igallery_img', true) )
			{
				$this->setRedirect('index.php?option=com_igallery&controller=igphoto&catid='.$this->input->get('catid',0,'INT'));
				return false;
			}
			
			$model = $this->getModel();

			$category = $model->getCategory($this->input->get('catid',0,'INT'));
			$profile = $model->getProfile($category->profile);

			if(!igFileHelper::makeResizedOnUpload($fileData, $profile, true))
			{
				return false;
			}
			
			if (!$model->store($fileData) ) 
			{
				return false;
			}
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false) );
	}
	
	function publish()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set($this->input->get('formtoken'), 1 );
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.igalleryfront.editimage.state', null, $cid[$i]))
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::publish();
	}
	
	function reorder()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set($this->input->get('formtoken'), 1 );
        $this->input->post->set('cid', $cid);
		
		if(!igGeneralHelper::authorise('core.igalleryfront.editimage.state', null, (int)$cid[0]))
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
            return false;
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::reorder();
	}
	
	function saveorder()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set('cid', $cid);

        $order = $this->input->get('order', array(), 'INT');
        $this->input->post->set('order', $order);

        $this->input->post->set($this->input->get('formtoken'), 1 );
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.igalleryfront.editimage.state', null, $cid[$i]))
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::saveorder();
	}
	
	function delete()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set($this->input->get('formtoken'), 1 );

		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.igalleryfront.deleteimage', null, $cid[$i]))
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}
		
		$this->view_list = 'images&catid='.$this->input->get('catid',0,'INT');
		parent::delete();
	}
	
	function rotate()
	{
		if(!igGeneralHelper::authorise('core.igalleryfront.editimage.state', null, $this->input->get('id', 0,'INT') ) )
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
            return false;
		}
		
		$model = $this->getModel();
	
		$msg = '';
		if( !$model->rotate() )
		{
			$msg = $model->getError();
		}

		$url = 'index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT').'&Itemid='.JFactory::getApplication()->input->get('Itemid', '','INT');
		$this->setRedirect(JRoute::_($url, false),$msg);
	}
	
	function assignMenuImage()
	{
		if(!igGeneralHelper::authorise('core.igalleryfront.editimage.state', null, $this->input->get('id', 0,'INT') ) )
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
            return false;
		}
		
		$model = $this->getModel();

		$msg = '';
		if( !$model->assignMenuImage() ) 
		{
			$msg = $model->getError();
		}
		
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false), $msg);
	}

	protected function getRedirectToListAppend()
	{
		return '&Itemid='.JFactory::getApplication()->input->get('Itemid', '','INT');
	}

}	