<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.modeladmin');

class igalleryModelcategory extends JModelAdmin
{
	public $skipJoins = false;
    public $tabletIsMobile = false;

	static $categories = array();
	static $profiles = array();

	function __construct()
	{
		if(JFile::exists(IG_COMPONENT.'/models/skip-joins.txt')){
			$this->skipJoins = true;
		}
		parent::__construct();
	}

	public function getForm($data = array(), $loadData = true)
	{
		return;
	}

	function getCategory($id)
	{
        $params = JComponentHelper::getParams('com_igallery');
        $input = JFactory::getApplication()->input;

	    if(empty($id) && ($input->get('view', 'category') == 'tags') )
        {
            $category = new stdClass();
            $category->id = 99999;
            $category->ordering = 0;
            $category->name = JText::_('IMAGE_TAGS').' - '.$input->get('igtags', '','STRING');
            $category->alias = 'gallery-tags';
            $category->profile = $input->get('igpid', 1,'INT');
            $category->parent = 0;
            $category->menu_image_filename = '';
            $category->menu_description = '';
            $category->gallery_description = '';
            $category->user = 0;
            $category->published = 1;
            $category->date = '';
            $category->hits = 0;
            $category->publish_up = '';
            $category->publish_down = '';
            $category->moderate = 0;
            $category->page_title = '';
            $category->metadesc = '';
            $category->second_user = 0;
            $category->third_user = 0;
            $category->fourth_user = 0;
            $category->password = '';
            $category->extra_field_1 = '';
            $category->extra_field_2 = '';
            $category->extra_field_3 = '';
            $category->extra_field_4 = '';
            $category->has_extra_fields = false;

            return $category;
        }

	    if( !isset(self::$categories[$id]) )
		{
        	$db	= $this->getDbo();
			$query = $db->getQuery(true);

			$query->select('c.*');
			$query->from('#__igallery AS c');

			$query->select('u.name AS displayname, u.username');
			$query->join('LEFT', '`#__users` AS u ON c.user = u.id');

			$query->where('c.id = '.(int)$id);
			$query->where('c.published = 1');
			$query->where('c.moderate = 1');

			$nullDate = $db->Quote($db->getNullDate());
			$nowDate = $db->Quote(JFactory::getDate()->toSql());
			$query->where('(c.publish_up = ' . $nullDate . ' OR c.publish_up <= ' . $nowDate . ' OR c.publish_up IS NULL)');
			$query->where('(c.publish_down = ' . $nullDate . ' OR c.publish_down >= ' . $nowDate . '  OR c.publish_down IS NULL)');

			$db->setQuery($query);
			$category = $db->loadObject();

            if(is_object($category))
            {
                $category->has_extra_fields = false;
                if( (!empty($category->extra_field_1) && $params->get('show_cat_xtra_1',0) == 1)  || (!empty($category->extra_field_2) && $params->get('show_cat_xtra_2',0) == 1) || (!empty($category->extra_field_3) && $params->get('show_cat_xtra_3',0) == 1) || (!empty($category->extra_field_4) && $params->get('show_cat_xtra_4',0) == 1) )
                {
                    $category->has_extra_fields = true;
                }
            }

			self::$categories[$id] = $category;
		}
	    return self::$categories[$id];
    }

	function getProfile($id)
	{
        $input = JFactory::getApplication()->input;

        if( !isset(self::$profiles[$id]) )
		{
        	$db	= $this->getDbo();
			$query = 'SELECT * FROM #__igallery_profiles WHERE published = 1 AND id = '.(int)$id;
			$db->setQuery($query);
			$profile = $db->loadObject();

			if(!isset($profile->id))
            {
                JFactory::getApplication()->enqueueMessage('Error the profile is not published');
                return false;
            }

			if( ($profile->thumb_position == 'left' || $profile->thumb_position == 'right') && $profile->images_per_row == 0)
			{
				$profile->images_per_row = 1;
			}

			if( ($profile->lbox_thumb_position == 'left' || $profile->lbox_thumb_position == 'right') && $profile->lbox_images_per_row == 0)
			{
				$profile->lbox_images_per_row = 1;
			}

            require_once(IG_ADMINISTRATOR_COMPONENT.'/lib/mobiledetect/Mobile_Detect.php');
            $detect = new IGMobile_Detect;

            $profile->phone = false;
            $profile->mobile = false;

            if( $detect->isMobile() )
            {
                $profile->mobile = true;

                $profile->transition = $profile->transition_touch;
                $profile->lbox_transition = $profile->transition_touch;
            }

            if($detect->isMobile() && (!$detect->isTablet() || $this->tabletIsMobile))
            {
                $profile->phone = true;

                if($profile->mobile_hide_thumbs == 1)
                {
                    $profile->show_thumbs = 0;
                    $profile->show_slideshow_controls = 1;
                    $profile->slideshow_position = 'left-right';
                    $profile->show_large_image = 1;
                }

                if($profile->lightbox_mobile_disable == 1)
                {
                    $profile->lightbox = 0;
                }


                $profile->lbox_show_thumbs = 0;
                $profile->lbox_show_slideshow_controls = 1;
                $profile->lbox_allow_comments = 0;


                $profile->comments_position = 'below';
                $profile->photo_des_position = 'below';

                $profile->lbox_photo_des_position = 'overlay';

                $profile->menu_grid_type = $profile->menu_grid_type == 'metro' ? 'by_rows' : $profile->menu_grid_type;
                $profile->thumb_grid_type = $profile->thumb_grid_type == 'metro' ? 'by_rows' : $profile->thumb_grid_type;

				$profile->lbox_fullscreen = $profile->lbox_fullscreen == 'open-fullscreen' ? 'show-icon' : $profile->lbox_fullscreen;
			}

            if( $detect->isiOS() )
            {
                $profile->lbox_fullscreen = 'none';
            }

            if($profile->transition_touch == 'slide' && $detect->isMobile())
            {
                $profile->show_slideshow_controls = 1;
                $profile->slideshow_position = 'left-right';
            }

            if($profile->lbox_transition_touch == 'slide' && $detect->isMobile())
            {
                $profile->lbox_show_slideshow_controls = 1;
                $profile->lbox_slideshow_position = 'left-right';
            }

            if($input->get('iglimit', 0,'INT') > 0)
            {
                $profile->thumb_pagination = 0;
            }

			self::$profiles[$id] = $profile;
		}

	    return self::$profiles[$id];
    }

	function getPagination($total, $limit, $prefix)
	{
		jimport('joomla.html.pagination');
		$pagination = new JPagination($total, JFactory::getApplication()->input->get($prefix.'limitstart', 0,'INT'), $limit, $prefix );
		return $pagination;
	}

	function getCategoryChildren($catId, $profile, $type, $source, $limit, $catIds)
	{
        $input = JFactory::getApplication()->input;
	    if( $input->get('view', 'category') == 'tags'){return array();}

	    $db	= $this->getDbo();
		$user = JFactory::getUser();
		$query = $db->getQuery(true);

		$query->select('c.*');
		$query->from('#__igallery AS c');
		$query->where('c.published = 1');
		$query->where('c.moderate = 1');
		$nullDate = $db->Quote($db->getNullDate());
		$nowDate = $db->Quote(JFactory::getDate()->toSql());
		$query->where('(c.publish_up = ' . $nullDate . ' OR c.publish_up <= ' . $nowDate . '  OR c.publish_up IS NULL)');
		$query->where('(c.publish_down = ' . $nullDate . ' OR c.publish_down >= ' . $nowDate . '  OR c.publish_down IS NULL)');

		$query->select('p.menu_max_width, p.menu_max_height, p.img_quality, p.menu_access');
		$query->join('INNER', '`#__igallery_profiles` AS p ON p.id = c.profile');

        if($profile->menu_access == 999)
        {
            if($user->guest)
            {
                $query->where('c.user = 99999');
            }
            else
            {
                $query->where('(c.user = '.(int)$user->id.' OR c.second_user ='.(int)$user->id.' OR c.third_user = '.(int)$user->id.' OR c.fourth_user = '.(int)$user->id.')');

            }
        }
        else
        {
            $groups	= implode(',', $user->getAuthorisedViewLevels() );
            $query->where('p.menu_access IN ('.$groups.')');
        }


        $query->select('u.name AS displayname, u.username');
		$query->join('LEFT', '`#__users` AS u ON c.user = u.id');

		if($this->skipJoins == false)
		{
			$query->select('COUNT(i.id) AS numimages');
			$query->group('c.id');
		}

		$catIdsForSql = array();

        switch($profile->menu_ordering) {

            case 'new_first' :
                $menuOrdering = 'c.date DESC';
                break;

            case 'new_last' :
                $menuOrdering = 'c.date ASC';
                break;

            case 'modified' :
                $menuOrdering = 'c.modified DESC';
                break;

            case 'a_z' :
                $menuOrdering = 'c.name ASC';
                break;

            case 'z_a' :
                $menuOrdering = 'c.name DESC';
                break;

            case 'hits' :
                $menuOrdering = 'c.hits DESC';
                break;

            case 'random' :
                $menuOrdering = 'RAND()';
                break;

            default:
                $menuOrdering = 'c.ordering';
                break;
        }

		switch($type)
        {
            case 'latest_menu_images' :
                foreach($catIds as $catIdValue)
                {
                    $children = $this->getChildIds($catIdValue);
                    $catIdsForSql = array_merge($catIdsForSql,$children);
                }
                $query->where('FIND_IN_SET(c.id,"'.implode(',',$catIdsForSql).'")');
	            if($this->skipJoins == false)
				{
					$query->join('INNER', '#__igallery_img AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1)' );
	            }
				$query->order('c.date DESC');
                break;
            case 'hits_menu_images' :
                foreach($catIds as $catIdValue)
                {
                    $children = $this->getChildIds($catIdValue);
                    $catIdsForSql = array_merge($catIdsForSql,$children);
                }
                $query->where('FIND_IN_SET(c.id,"'.implode(',',$catIdsForSql).'")');
	            if($this->skipJoins == false)
				{
		            $query->join('INNER', '#__igallery_img AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1)');
	            }
				$query->order('c.hits DESC');
                break;
            case 'random_menu_images' :
                foreach($catIds as $catIdValue)
                {
                    $children = $this->getChildIds($catIdValue);
                    $catIdsForSql = array_merge($catIdsForSql,$children);
                }
                $query->where('FIND_IN_SET(c.id,"'.implode(',',$catIdsForSql).'")');
	            if($this->skipJoins == false)
	            {
		            $query->join('INNER', '#__igallery_img AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1)');
	            }
				$query->order('RAND()');
                break;
            default:
                $query->where('c.parent IN ('.implode(',',$catIds).')');
	            if($this->skipJoins == false)
	            {
					$query->join('LEFT', '#__igallery_img AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1)');
	            }
				$query->order($menuOrdering);
                break;
        }

        $this->menuTotal = $this->_getListCount($query);

		if($profile->menu_pagination == 1)
		{
			$categoryChildren = $this->_getList($query, $input->get('menu_limitstart', 0,'INT'), $profile->menu_pagination_amount );
		}
		else if( $limit > 0)
		{
            $categoryChildren = $this->_getList($query, 0 , $limit);
        }
        else
        {
            $categoryChildren = $this->_getList($query);
		}

        $this->addSelectedMenuImages($categoryChildren);
		$this->addFirstMenuImages($categoryChildren);

		$categoryChildren = array_values($categoryChildren);

        if($profile->menu_grid_type == 'metro')
        {
            $ratios = array();
            $targetTallImages = round( count($categoryChildren)/12 );
            $targetWideImages = round( count($categoryChildren)/12 );
            $targetBigImages = round( count($categoryChildren)/12 );

            for($i=0; $i<count($categoryChildren); $i++)
            {
                $row = $categoryChildren[$i];

                $fileName = '';
                $folderName = '';

                if(!empty($row->menu_image_filename))
                {
                    $fileName = $row->menu_image_filename;
                    if($row->filesys == 1)
                    {
                        $folderName = $row->folder;
                    }
                    else
                    {
                        $increment = igFileHelper::getIncrementFromFilename($fileName);
                        $folderName = igFileHelper::getFolderName($increment);
                    }
                }
                else if(!empty($row->selected_menu_filename))
                {
                    $fileName = $row->selected_menu_filename;
                    if($row->selected_menu_filesys == 1)
                    {
                        $folderName = $row->selected_menu_folder;
                    }
                    else
                    {
                        $increment = igFileHelper::getIncrementFromFilename($row->selected_menu_filename);
                        $folderName = igFileHelper::getFolderName($increment);
                    }
                }
                else if(!empty($row->first_menu_filename))
                {
                    $fileName = $row->first_menu_filename;
                    if($row->selected_menu_filesys == 1)
                    {
                        $folderName = $row->selected_menu_folder;
                    }
                    else
                    {
                        $increment = igFileHelper::getIncrementFromFilename($row->first_menu_filename);
                        $folderName = igFileHelper::getFolderName($increment);
                    }
                }

                if(!empty($fileName))
                {
                    $sourceFile = IG_ORIG_PATH.'/'.$folderName.'/'.$fileName;

                    $imgSize = getimagesize($sourceFile);
                    $ratios[$i] = $imgSize[0]/$imgSize[1];
                }
                else
                {
                    $ratios[$i] = 1;
                }
            }

            asort($ratios);
            $tallIndexes = array();
            $ratiosForTall = $ratios;
            for($k=0; $k<$targetTallImages; $k++)
            {
                $key = key($ratiosForTall);
                $tallIndexes[] = $key;
                unset($ratiosForTall[$key]);
            }

            arsort($ratios);
            $wideIndexes = array();
            $ratiosForWide = $ratios;
            for($k=0; $k<$targetWideImages; $k++)
            {
                $key = key($ratiosForWide);
                $wideIndexes[] = $key;
                unset($ratiosForWide[$key]);
            }

            $bigIndexes = array();
            $keys = array_keys($ratios);
            for($k=0; $k<$targetBigImages; $k++)
            {
                $index = $keys[round(count($keys)/2)];

                $bigIndexes[] = $index;
                unset($keys[$index]);
                $keys = array_values($keys);
            }
        }

		for($i=0; $i<count($categoryChildren); $i++ )
		{
            if( $source != 'component' && ($input->get('igpid', 0,'INT') > 0) )
            {
                $profileId = $input->get('igpid', 0,'INT');
            }
			else if( empty($categoryChildren[$i]->parent) )
			{
				$profileId = $categoryChildren[$i]->profile;
			}
			else
			{
				$parentCat = $this->getCategory($categoryChildren[$i]->parent);
				$profileId = $parentCat->profile;
			}

			$profile = $this->getProfile($profileId);

            if($profile->menu_grid_type == 'metro')
            {
                $smaller = min($profile->menu_max_width,$profile->menu_max_height);

                $profile->menu_max_width = $smaller;
                $profile->menu_max_height = $smaller;
                $profile->crop_menu = 1;

                $categoryChildren[$i]->menuHeightDouble = 0;
                $categoryChildren[$i]->menuWidthDouble = 0;

                if( in_array($i,$tallIndexes))
                {
                    $menuHeight = ($profile->menu_max_height * 2) + $profile->menu_grid_spacing;
                    $menuWidth = $profile->menu_max_width;
                    $categoryChildren[$i]->menuHeightDouble = 1;
                }
                else if( in_array($i,$wideIndexes))
                {
                    $menuWidth = ($profile->menu_max_width * 2) + $profile->menu_grid_spacing;
                    $menuHeight = $profile->menu_max_height;
                    $categoryChildren[$i]->menuWidthDouble = 1;
                }
                else if( in_array($i,$bigIndexes))
                {
                    $menuWidth = ($profile->menu_max_width * 2) + $profile->menu_grid_spacing;
                    $menuHeight = ($profile->menu_max_height * 2) + $profile->menu_grid_spacing;
                    $categoryChildren[$i]->menuHeightDouble = 1;
                    $categoryChildren[$i]->menuWidthDouble = 1;
                }
                else
                {
                    $menuWidth = $profile->menu_max_width;
                    $menuHeight = $profile->menu_max_height;
                }
            }
            else
            {
                $menuWidth = $profile->menu_max_width;
                $menuHeight = $profile->menu_max_height;
            }

			$categoryChildren[$i]->menu_max_width = $profile->menu_max_width;
			$categoryChildren[$i]->menu_max_height = $profile->menu_max_height;

			$menuPhoto = new stdClass();

			if( !empty($categoryChildren[$i]->menu_image_filename) )
			{
				$menuPhoto = new stdClass();
				$menuPhoto->filename = $categoryChildren[$i]->menu_image_filename;
				$menuPhoto->rotation = 0;
                $menuImageFolder = $categoryChildren[$i]->folder;
                $menuImageFilesys = $categoryChildren[$i]->filesys;
			}
			elseif( !empty($categoryChildren[$i]->selected_menu_filename) )
			{
				$menuPhoto = new stdClass();
				$menuPhoto->filename = $categoryChildren[$i]->selected_menu_filename;
				$menuPhoto->rotation = $categoryChildren[$i]->selected_menu_rotation;
                $menuImageFolder = $categoryChildren[$i]->selected_menu_folder;
                $menuImageFilesys = $categoryChildren[$i]->selected_menu_filesys;
			}
			elseif( !empty($categoryChildren[$i]->first_menu_filename) && $profile->menu_image_defaults == 1)
			{
				$menuPhoto = new stdClass();
				$menuPhoto->filename = $categoryChildren[$i]->first_menu_filename;
				$menuPhoto->rotation = $categoryChildren[$i]->first_menu_rotation;
                $menuImageFolder = $categoryChildren[$i]->selected_menu_folder;
                $menuImageFilesys = $categoryChildren[$i]->selected_menu_filesys;
			}

			if( !empty($menuPhoto->filename) )
			{
                $folderName = $menuImageFilesys == 1 ? $menuImageFolder : '';
			    $categoryChildren[$i]->fileArray = igFileHelper::originalToResized($menuPhoto->filename, $folderName, '',
                $menuWidth, $menuHeight, $profile->img_quality, $profile->crop_menu,
	            $menuPhoto->rotation, $profile->round_menu, $profile->round_fill);
	        }

        }

		return $categoryChildren;
	}

	function addSelectedMenuImages(&$categoryChildren)
	{
		$ids= array();
		foreach($categoryChildren as $categoryChild)
		{
			$ids[] = (int)$categoryChild->id;
		}

		$db	= $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('c.id,c.folder');
		$query->from('#__igallery AS c');
		$query->where('FIND_IN_SET(c.id,"'.implode(',',$ids).'")');
		$query->select('i.filename AS selected_menu_filename, i.rotation as selected_menu_rotation, i.filesys');
		$query->join('INNER', '`#__igallery_img` AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1 AND i.menu_image = 1)');
		$selectedMenuRows = $this->_getList($query);

		foreach($categoryChildren as $key => $categoryChild)
		{
			foreach($selectedMenuRows as $selectedMenuRow)
			{
				if($categoryChild->id == $selectedMenuRow->id)
				{
					if(!empty($selectedMenuRow->selected_menu_filename) )
					{
						$categoryChildren[$key]->selected_menu_filename = $selectedMenuRow->selected_menu_filename;
						$categoryChildren[$key]->selected_menu_rotation = $selectedMenuRow->selected_menu_rotation;
                        $categoryChildren[$key]->selected_menu_folder = $selectedMenuRow->folder;
                        $categoryChildren[$key]->selected_menu_filesys = $selectedMenuRow->filesys;
					}
				}
			}
		}

	}

	function addFirstMenuImages(&$categoryChildren)
	{
		$ids= array();
		foreach($categoryChildren as $categoryChild)
		{
			$ids[] = (int)$categoryChild->id;
		}

		$db	= $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('c.id, c.folder');
		$query->from('#__igallery AS c');
		$query->where('FIND_IN_SET(c.id,"'.implode(',',$ids).'")');
		$query->select('i.filename AS first_menu_filename, i.rotation as first_menu_rotation, i.filesys');
		$query->join('INNER', '`#__igallery_img` AS i ON (i.gallery_id = c.id AND i.published = 1 AND i.moderate = 1 AND i.ordering = 1)');
		$firstMenuRows = $this->_getList($query);

		foreach($categoryChildren as $key => $categoryChild)
		{
			foreach($firstMenuRows as $firstMenuRow)
			{
				if($categoryChild->id == $firstMenuRow->id)
				{
					if(!empty($firstMenuRow->first_menu_filename) )
					{
						$categoryChildren[$key]->first_menu_filename = $firstMenuRow->first_menu_filename;
						$categoryChildren[$key]->first_menu_rotation = $firstMenuRow->first_menu_rotation;
                        $categoryChildren[$key]->selected_menu_folder = $firstMenuRow->folder;
                        $categoryChildren[$key]->selected_menu_filesys = $firstMenuRow->filesys;
					}
				}
			}
		}

	}

	function addCategoryHit($catid)
	{
		$db	= $this->getDbo();
		$query = 'UPDATE #__igallery SET hits = hits + 1 WHERE id = '.(int)$catid;
		$db->setQuery($query);
		$db->execute();
	}


	function getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds, $rated=false)
	{
        $params = JComponentHelper::getParams('com_igallery');
	    $input = JFactory::getApplication()->input;
	    $db	= $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('i.*');
		$query->from('#__igallery_img AS i');

		$query->select('c.name, c.folder');
		$query->join('INNER', '`#__igallery` AS c ON c.id = i.gallery_id');

		$query->select('p.thumb_pagination_amount, p.thumb_pagination, p.image_ordering');
		$query->join('INNER', '`#__igallery_profiles` AS p ON p.id = c.profile');

		$query->select('u.name AS displayname, u.username');
		$query->join('LEFT', '`#__users` AS u ON i.user = u.id');

        if($profile->allow_rating == 2 || $profile->lbox_allow_rating == 2 || strpos($order,'rating_average') !== false )
		{
			$join = $rated == true ? 'INNER' : 'LEFT';
			$query->select('ROUND( SUM(r.rating)/COUNT(r.rating), 1) AS rating_average, COUNT(r.rating) as rating_count');
			$query->join($join, '`#__igallery_ratings` AS r ON i.id = r.image_id AND r.published = 1');
			$query->group('i.id');
		}

		if(!empty($where))
		{
			$query->where($where);
		}

		if($child && ($input->get('view', 'category') == 'tags') )
		{
			$children = $this->getAllIds();
			$query->where('FIND_IN_SET(i.gallery_id,"'.implode(',',$children).'")');
		}
		else if($child)
		{
            $catIdsForSql = array();
		    foreach($catIds as $catIdValue)
            {
                $children = $this->getChildIds($catIdValue);
                $children[] = (int)$catIdValue;
                $catIdsForSql = array_merge($catIdsForSql,$children);
            }

            $query->where('FIND_IN_SET(i.gallery_id,"'.implode(',',$catIdsForSql).'")');
		}
		else
		{
			if(count($catIds) == 1)
            {
                $query->where('i.gallery_id = '.(int)$catid);
            }
			else
            {
                $query->where('FIND_IN_SET(i.gallery_id,"'.implode(',',$catIds).'")');
            }
		}

		if(!empty($tags))
		{
			$tagsArray = explode(',', $tags);
			$tagsLikeSql = array();

			foreach($tagsArray as $key => $value)
			{
                if($params->get('tags_match','partial') == 'exact')
                {
                    $tagsLikeSql[] = 'FIND_IN_SET('.$db->Quote( trim($value)).',i.tags) > 0 ';
                }
                else
                {
                    $likeValue = $db->Quote('%'.$db->escape($value, true).'%', false);
                    $tagsLikeSql[] = 'i.tags LIKE '.$likeValue;
                    $tagsLikeSql[] = 'i.description LIKE '.$likeValue;
                    $tagsLikeSql[] = 'i.alt_text LIKE '.$likeValue;
                    $tagsLikeSql[] = 'i.filename LIKE '.$likeValue;
                }

			}
			$tagClauses = implode( ' OR ', $tagsLikeSql );
			$query->where('('.$tagClauses.')');
		}

		$query->where('i.published = 1');
		$query->where('i.moderate = 1');

		$nullDate = $db->Quote($db->getNullDate());
		$nowDate = $db->Quote(JFactory::getDate()->toSql());
		$query->where('(i.publish_up = ' . $nullDate . ' OR i.publish_up <= ' . $nowDate . '  OR i.publish_up IS NULL)');
		$query->where('(i.publish_down = ' . $nullDate . ' OR i.publish_down >= ' . $nowDate . ' OR i.publish_down IS NULL)');

		$user	= JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels() );
		$query->where('i.access IN ('.$groups.')');

		$query->order($order);

        $this->thumbTotal = $this->_getListCount($query);

		if($profile->thumb_pagination == 1)
		{
			$photoList = $this->_getList($query, $input->get('thumb_limitstart', 0,'INT'), (int)$profile->thumb_pagination_amount);
		}
		else
		{
			if(!empty($limit))
			{
				$photoList = $this->_getList($query, 0 , $limit);
			}
			else
			{
				$photoList = $this->_getList($query);
			}
		}

		return $photoList;
	}

	function addComments($photoList)
	{
		$ids= array();
		foreach($photoList as $photo)
		{
			$ids[] = (int)$photo->id;
		}

		$db	= $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('co.*');
		$query->from('#__igallery_comments AS co');

		$query->select('u.name AS comments_displayname, u.username AS comments_username');
		$query->join('LEFT', '`#__users` AS u ON co.user = u.id');

		$query->where('FIND_IN_SET(co.image_id,"'.implode(',',$ids).'")');

		$query->where('co.published =  1');

		$comments = $this->_getList($query);

		foreach($photoList as $key => $photo)
		{
			$photoList[$key]->comments = array();

			foreach($comments as $comment)
			{
				if($photo->id == $comment->image_id)
				{
					$photoList[$key]->comments[] = $comment;
				}
			}
		}

		return $photoList;
	}

	function getCategoryImagesList($profile, $catid, $tags, $child, $limit, $catIds)
	{
        $input = JFactory::getApplication()->input;
	    if( $input->get('view', 'category') != 'tags')
        {
            $this->addCategoryHit($catid);
        }

		$select = 'i.*';
		$where = '';

        switch ($profile->image_ordering)
        {
            case 'new_first':
                $order = 'i.date DESC';
                break;
            case 'new_last':
                $order = 'i.date ASC';
                break;
            case 'random':
                $order = 'RAND()';
                break;

            case 'a_z':
                $order = 'i.filename ASC';
                break;

            case 'z_a':
                $order = 'i.filename DESC';
                break;

            case 'exif_first':
                $order = 'i.exif_date DESC, i.date DESC';
                break;

            case 'exif_last':
                $order = 'i.exif_date ASC, i.date ASC';
                break;

            default:
                $order = 'i.ordering';
        }

		$photoList = $this->getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds);

		return $photoList;
	}

	function getRandomList($profile, $catid, $tags, $child, $limit, $catIds)
	{
		$db	= $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('id');
		$query->from('#__igallery_img as i');
		if($child)
		{
            $catIdsForSql = array();
		    foreach($catIds as $catIdValue)
            {
                $children = $this->getChildIds($catIdValue);
                $children[] = (int)$catIdValue;
                $catIdsForSql = array_merge($catIdsForSql,$children);
            }
            $query->where('FIND_IN_SET(i.gallery_id,"'.implode(',',$catIdsForSql).'")');
		}
		else
		{
		    if(count($catIds) == 1)
            {
                $query->where('i.gallery_id = '.(int)$catid);
            }
            else
            {
                $query->where('FIND_IN_SET(i.gallery_id,"'.implode(',',$catIds).'")');
            }
		}

        if(!empty($tags))
        {
            $tagsArray = explode(',', $tags);
            $tagsLikeSql = array();

            foreach($tagsArray as $key => $value)
            {
                $tagsLikeSql[] = 'FIND_IN_SET('.$db->Quote( trim($value)).',i.tags) > 0 ';
            }
            $tagClauses = implode( ' OR ', $tagsLikeSql );
            $query->where('('.$tagClauses.')');
        }

        $query->where('i.published = 1');
		$query->where('i.moderate = 1');
		$user	= JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels() );
		$query->where('i.access IN ('.$groups.')');
		$db->setQuery($query);
		$rows = $db->loadAssocList();

		$allIds = array();

		foreach($rows as $row)
		{
			$allIds[(int)$row['id']] = (int)$row['id'];
		}

		$allIdsCount = count($allIds);
		$limit = $limit == 0 ? 100 : $limit;
		$randomLimit =  $allIdsCount < $limit ? $allIdsCount : $limit;
		$randomKeys = (array)array_rand($allIds, $randomLimit);

		$select = 'i.*';
		$where = 'FIND_IN_SET(i.id,"'.implode(',',$randomKeys).'")';
		$order = 'RAND()';
		$photoList = $this->getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds, false);

		return $photoList;
	}

	function getLatestList($profile, $catid, $tags, $child, $limit, $catIds)
	{
		$select = 'i.*';
		$where = null;
		$order = 'date DESC';
		$photoList = $this->getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds);

		return $photoList;
	}

	function getHitsList($profile, $catid, $tags, $child, $limit, $catIds)
	{
		$select = 'i.*';
		$where = null;
		$order = 'hits DESC';
		$photoList = $this->getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds);

		return $photoList;
	}

	function getRatedList($profile, $catid, $tags, $child, $limit, $catIds)
	{
		$select = 'i.*';
		$where = null;
		$order = 'rating_average DESC, rating_count DESC';
		$photoList = $this->getImagesList($select, $profile, $catid, $tags, $where, $order, $child, $limit, $catIds, true);

		return $photoList;
	}

	function getChildIds($parentId)
	{
		$categories = igStaticHelper::getCategories();
        $childIds = igTreeHelper::getChildIds($categories, $parentId);

        return $childIds;
    }

    function getAllIds()
	{
		$ids = array();

		$db	= JFactory::getDBO();
		$query = 'SELECT id FROM #__igallery WHERE published = 1';
		$db->setQuery($query);
		$categories = $db->loadObjectList();

		foreach($categories as $category)
		{
			$ids[] = $category->id;
		}

        return $ids;
    }

	public function getTable($type = 'igallery', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

}

class igModelcategory extends igalleryModelcategory{};
