<?php

use Joomla\CMS\Plugin\PluginHelper;

defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.application.component.modeladmin');

class igalleryModelimagefront extends JModelAdmin
{

	public function getTable($type = 'igallery_img', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		return;
	}

	function getPhoto($id)
	{
        $db	= $this->getDbo();
		$query = 'SELECT * FROM #__igallery_img WHERE id = '. (int)$id;
		$db->setQuery($query);
		$photo = $db->loadObject();
		return $photo;
	}

	function getCategory($id)
	{
        $db	= $this->getDbo();
		$query = 'SELECT * FROM #__igallery WHERE id = '.(int)$id;
		$db->setQuery($query);
		$category = $db->loadObject();
	    return $category;
    }

	function getProfile($id)
	{
        $db	= $this->getDbo();
		$query = 'SELECT * FROM #__igallery_profiles WHERE id = '.(int)$id;
		$db->setQuery($query);
		$profile = $db->loadObject();
	    return $profile;
    }

	function addHit($id)
	{
        $db	= $this->getDbo();
		$row = $this->getTable('igallery_img');
		$row->load( (int)$id );
		$row->hits = $row->hits + 1;
		if(!$row->store())
		{
			$this->setError($row->getError());
			return false;
		}
		return true;
	}

	function addRating()
	{
        $input = JFactory::getApplication()->input;
	    $params = JComponentHelper::getParams('com_igallery');

        if($params->get('rating_allow_guest', 1) == 0)
        {
            if(JFactory::getUser()->get('guest') == true)
            {
                $this->setError( JText::_('PLEASE_LOGIN_TO_RATE_IMAGES') );
                return false;
            }
        }

	    $imageId = $input->get('imageid', 0,'INT');
	    $rating = $input->get('rating', 0,'INT');

	    if( $rating < 1 || $rating > 5 )
	    {
            $this->setError('Rating: '.$rating.' is out of the range 1-5' );
            return false;
        }

        $db	= JFactory::getDBO();
	    $query = $db->getQuery(true);

	    $query->select('i.id');
		$query->from('#__igallery_img AS i');
		$query->where('i.id = '.(int)$imageId);
		$db->setQuery($query);
		$image = $db->loadObject();

		if(!isset($image->id))
        {
            $this->setError('Error, image with id: '.$imageId. ' Does not exist' );
            return false;
        }

        $query = $db->getQuery(true);
		$query->select('r.*');
		$query->from('#__igallery_ratings AS r');

		$query->where('r.image_id = '.(int)$imageId);
        $db->setQuery($query);
		$ratings = $db->loadObjectList();

        foreach($ratings as $rating)
        {
            if( JFactory::getUser()->get('guest') == true )
			{
				if( $rating->ip == substr($_SERVER['REMOTE_ADDR'],0,23) )
				{
					$interval = $params->get('rating_interval', 24) * 3600;

					if( time() < $rating->date + $interval )
					{
						$this->setError( JText::_('ALREADY_VOTED') );
						return false;
					}
				}
			}
			else
			{
				if( $rating->user == JFactory::getUser()->id )
				{
					$interval = $params->get('rating_interval', 24) * 3600;

					if( time() < $rating->date + $interval )
					{
						$this->setError( JText::_('ALREADY_VOTED') );
						return false;
					}
				}
			}
        }

		$row = $this->getTable('igallery_ratings');

		$row->image_id = (int)$imageId;
		$row->rating = (int)$input->get('rating', 0,'INT');
		$row->ip = substr($_SERVER['REMOTE_ADDR'],0,23);
		$row->user = (int)JFactory::getUser()->id;
		$row->published = 1;
		$row->date = time();

		if(!$row->store())
		{
			$this->setError( $row->getError() );
			return false;
		}

        return true;
    }

    function getRatingAverage()
    {
        $input = JFactory::getApplication()->input;
        $imageId = $input->get('imageid', 0,'INT');

        $db	= JFactory::getDBO();
	    $query = $db->getQuery(true);
		$query->select('r.*');
		$query->from('#__igallery_ratings AS r');

		$query->where('r.image_id = '.(int)$imageId);
        $db->setQuery($query);
		$ratings = $db->loadObjectList();

		$sum = 0;
		$count = 0;
		foreach($ratings as $rating)
        {
            $sum = $sum + $rating->rating;
            $count++;
        }
        $average = round( ($sum/$count), 2);

        return $average;
    }

	function addComment()
	{
        $input = JFactory::getApplication()->input;
	    $params = JComponentHelper::getParams('com_igallery');
		$permission = $params->get('comments-permission', 'registered');
		if($permission == 'registered')
		{
			if(JFactory::getUser()->get('guest') == true)
			{
				$this->setError( JText::_('Please Login to Comment on Images') );
				return false;
			}
		}
		else
		{
			$recaptureVar = $input->get('g-recaptcha-response','','STRING');
            PluginHelper::importPlugin('captcha');
			$result = JFactory::getApplication()->triggerEvent('onCheckAnswer',array($recaptureVar));
			if(!$result[0])
			{
				$this->setError( JText::_('ReCapture Result Failed') );
				return false;
			}
		}

	    $imageId = $input->get('imageid', 0,'INT');
	    $comment = $input->get('comment', '','STRING');

	    if(empty($comment) )
	    {
            $this->setError('Comment is Empty');
            return false;
        }

        $db	= JFactory::getDBO();
	    $query = $db->getQuery(true);

	    $query->select('i.id');
		$query->from('#__igallery_img AS i');
		$query->where('i.id = '.(int)$imageId);
		$db->setQuery($query);
		$image = $db->loadObject();

		if(!isset($image->id))
        {
            $this->setError('Error, image with id: '.$imageId. ' Does not exist' );
            return false;
        }

		$row = $this->getTable('igallery_comments');

		$row->image_id = (int)$imageId;
		$row->comment = $input->get('comment','','STRING');
		$row->ip = substr($_SERVER['REMOTE_ADDR'],0,23);
		$row->user = (int)JFactory::getUser()->id;
		$row->published = 1;
		$row->date = time();

		if(!$row->store())
		{
			$this->setError( $row->getError() );
			return false;
		}

        $app = JFactory::getApplication();
		$sessionValue = $app->getUserState('com_igallery.addcomment', 0);
        $configArray = JComponentHelper::getParams('com_igallery');

        if(empty($sessionValue) )
        {
            if($configArray->get('notify_new_comment', 0) == 1)
            {
                $siteConfig = JFactory::getConfig();
                $from = $siteConfig->get('mailfrom');
                $fromname = $siteConfig->get('fromname');
                $recipient = explode(',', $configArray->get('notify_emails', '') );
                $subject = $siteConfig->get('sitename').' : New Comment Added';

                $body = IG_HOST.'administrator/index.php?option=com_igallery&view=comments';

                for($i=0; $i<count($recipient); $i++)
                {
                    $mail = JFactory::getMailer();
                    $mail->sendMail($from, $fromname, $recipient[$i], $subject, $body);
                    if($i > 5){break;}
                }

                $app->setUserState('com_igallery.addcomment',1);
            }
        }

        return true;
    }

}
