<?php

defined('_JEXEC') or die;

function igalleryBuildRoute(&$query)
{
    require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/helpers/static.php');
    require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/helpers/tree.php');

    $segments = array();
    $catIdOfActive = 0;

    if( isset($query['view']) && isset($query['igid']) )
    {
        if($query['view'] == 'category')
        {
            if( isset($query['Itemid']) )
            {
                $app	= JFactory::getApplication();
                $menu	= $app->getMenu();
                $activeMenu = $menu->getItem($query['Itemid']);
                if( isset($activeMenu->query['igid']) )
                {
                    $catIdOfActive = $activeMenu->query['igid'];
                }
            }

            $categories = igStaticHelper::getCategories();
            $parents = igTreeHelper::getParentPath($categories, $query['igid'], true);

            foreach($parents as $parent)
            {
                if($parent->id != $catIdOfActive)
                {
                    array_unshift($segments, $parent->alias);
                }
                else
                {
                    break;
                }
            }

            unset($query['view']);
            unset($query['igid']);
        }
    }

    if( isset($query['view']) )
    {
        if($query['view'] == 'tags')
        {
            unset($query['view']);
        }
    }

    return $segments;
}

function igalleryParseRoute($segments)
{
    $vars = array();
    $count = count($segments);
    $lastSegment = $segments[$count - 1];

    $lastSegment = str_replace(':', '-', $lastSegment);

    $db = JFactory::getDBO();
    $dbQuery = 'SELECT id FROM #__igallery WHERE alias = "'.$db->escape($lastSegment).'"';
    $db->setQuery($dbQuery);
    $row = $db->loadObject();
    if(!$row)
    {
        JFactory::getApplication()->enqueueMessage('Ignite Gallery Router Error: Page Not Found');
        return $vars;
    }
    $vars['igid'] = $row->id;
    $vars['view'] = 'category';
    if(JVersion::MAJOR_VERSION == 4)
    {
        $router = JFactory::getApplication()->getRouter();
        $router->attachParseRule('igalleryParseRule', 'postprocess');
    }

    return $vars;
}

function igalleryParseRule(&$router, &$uri)
{
    $uri->setPath('');
}

?>