<?php
defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Plugin\PluginHelper;

jimport('joomla.application.component.view');


class igalleryViewcategory extends JViewLegacy
{
    static $imageLists = array();

    public function __construct($config = array())
    {
        $config['template_path'] = JPATH_SITE.'/components/com_igallery/views/category/tmpl';
        parent::__construct($config);
    }

    function display($tpl = null)
	{
	    $this->removeCanonical();

        $app = JFactory::getApplication();
        $this->input = $app->input;
        $this->user = JFactory::getUser();
	    $this->guest = $this->user->get('guest') ? true : false;
        $this->params = JComponentHelper::getParams('com_igallery');
	    $model = $this->getModel();
        $this->languageTag = JFactory::getLanguage()->getTag();
        $this->currentUrl = Uri::getInstance()->toString();
        $this->activeImage = 0;
        $this->source = $this->input->get('igsource', 'component');
        $this->lboxView = $this->input->get('lboxview', 0,'INT');

        $catidArray = explode(',',$this->input->get('igid', 0,'STRING'));

		foreach($catidArray as $key => $value)
        {
            $catidArray[$key] = (int)$value;

            if($catidArray[$key] == 0)
            {
                unset($catidArray[$key]);
            }
        }
        $this->catid = empty($catidArray) ? 0 : $catidArray[0];
        $this->catids = $catidArray;

        $tags = $this->input->get('igtags', '','STRING');
    	$searchChildren = $this->input->get('igchild', 0,'INT');
    	if(strlen($tags) > 0){$searchChildren=1;}

    	$this->type = $this->input->get('igtype', 'category');
    	$profileId = $this->input->get('igpid', 0,'INT');
    	$this->Itemid = $this->input->get('Itemid', '','INT');
    	$this->ajaxUrlImageName = $this->input->get('i', '');
        $this->urlImageName = $this->input->get('image', '');
        $limit = $this->input->get('iglimit', 0,'INT');
        $limit = $limit == 0 ? 1000 : $limit;
        $uniqueid = $this->input->get('iguniqueid', 0);
        $this->uniqueid = !empty($uniqueid) ? $uniqueid : $this->catid;
        $this->hasTags = false;
        $this->currentUrl = Uri::getInstance()->toString();
        $this->currentUrl = strpos($this->currentUrl, '&i=') !== false ? substr($this->currentUrl, 0, strpos($this->currentUrl, '&i=')) : $this->currentUrl;
        $this->currentUrl = strpos($this->currentUrl, '?i=') !== false ? substr($this->currentUrl, 0, strpos($this->currentUrl, '?i=')) : $this->currentUrl;


        if($this->source != 'component')
		{
			$overridePath = JPATH_BASE.'/templates/'.$app->getTemplate().'/html/com_igallery/'.$this->getName();
			$this->_addPath('template', $overridePath);
		}

        $this->category = $model->getCategory($this->catid);

		if($this->category == null)
	    {
            JFactory::getApplication()->enqueueMessage('Error the gallery with an id of: '.$this->catid.' is not published' );
	        return;
	    }

        $this->category->password = trim($this->category->password);
        if( !empty($this->category->password) && JFactory::getSession()->get('igpassword.'.$this->category->id, '') != 'correct')
        {
            $this->setMetaData(true);
            parent::display('password_form');
            return true;
        }

        $profileId = $profileId == 0 ? $this->category->profile : $profileId;
		$this->profile = $model->getProfile($profileId);

		if($this->profile == null)
		{
            JFactory::getApplication()->enqueueMessage('Profile Unpublished');
			return;
		}

		if($this->profile->show_large_image == 0 && $this->profile->show_thumbs == 0)
		{
            JFactory::getApplication()->enqueueMessage('Thumbs or main image display must be enabled in profile settings');
			return;
		}

        $this->profile->refresh_mode = $this->source == 'module' ? 'javascript' : $this->profile->refresh_mode;
        $this->profile->refresh_mode = $this->input->get('igplugincalled', 0,'INT') == 1 ? 'javascript' : $this->profile->refresh_mode;


        if($this->source == 'plugin')
		{
            $this->input->set('igplugincalled', 1);
		}

		$this->registerLink = $this->params->get('register_link', 'index.php?option=com_users&amp;task=register');

        if($this->profile->access == 999)
        {
            $owners = array();
            $owners[] = $this->category->user;
            if(!empty($this->category->second_user)){$owners[] = $this->category->second_user;}
            if(!empty($this->category->third_user)){$owners[] = $this->category->third_user;}
            if(!empty($this->category->fourth_user)){$owners[] = $this->category->fourth_user;}

            if(!in_array($this->user->id, $owners))
            {
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
            }
        }
        else if( !in_array($this->profile->access, $this->user->getAuthorisedViewLevels() ) )
		{
			if($this->profile->access == 2)
			{
                JFactory::getApplication()->enqueueMessage(JText::_( 'PLEASE_LOGIN_TO_VIEW' ));
			    JFactory::getApplication()->redirect( JRoute::_($this->registerLink.'&return='.urlencode(base64_encode(Uri::getInstance()->toString())),false ) );
                return;
			}
			else
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}

        if( ($this->source == 'component' && $this->input->get('igtags', '') == '') || $this->type == 'child_menu_images' || $this->type == 'latest_menu_images' || $this->type == 'hits_menu_images' || $this->type == 'random_menu_images')
        {
            $this->categoryChildren = $model->getCategoryChildren($this->catid, $this->profile, $this->type, $this->source, $limit, $this->catids);
        }
        else
        {
            $this->categoryChildren = array();
        }

        if($this->source == 'component' || $this->type == 'category' || $this->type == 'latest' || $this->type == 'hits' || $this->type == 'rated' || $this->type == 'random')
        {
            switch($this->type)
            {
                case 'random' : $this->photoList = $model->getRandomList($this->profile, $this->catid, $tags, $searchChildren, $limit, $this->catids);break;
                case 'latest' : $this->photoList = $model->getLatestList($this->profile, $this->catid, $tags, $searchChildren, $limit, $this->catids);break;
                case 'hits'   : $this->photoList = $model->getHitsList($this->profile, $this->catid, $tags, $searchChildren, $limit, $this->catids);break;
                case 'rated'  : $this->photoList = $model->getRatedList($this->profile, $this->catid, $tags, $searchChildren, $limit, $this->catids);break;
                default       : $this->photoList = $model->getCategoryImagesList($this->profile, $this->catid, $tags, $searchChildren, $limit, $this->catids);
            }
        }
        else
        {
            $this->photoList =  array();
        }

        if($this->profile->allow_comments == 1 || $this->profile->lbox_allow_comments == 1)
		{
			$this->photoList = $model->addComments($this->photoList);
		}

        if( empty($this->photoList) && empty($this->categoryChildren) )
        {
            if ($this->input->get('view', 'category') == 'tags')
            {
                if(empty($tags))
                {
                    echo '<div class="alert alert-info"><div class="alert-message">This menu item will be used when an image tag is clicked on. Please put this menu item on a hidden menu. See the common questions in the gallery documentation for more info.</div></div>';
                }
                else
                {
                    echo '<div class="alert alert-info"><div class="alert-message">No Images with the tag: '.$tags.' found</div></div>';
                }
            }
            else
            {
                echo '<div class="alert alert-info"><div class="alert-message">'.JText::_('NO_IMAGES_OR_GALLERIES_FOUND').'</div></div>';
            }
        }

    	if($this->profile->menu_pagination == 1 && count($this->categoryChildren) )
    	{
	        $this->menuPagination = $model->getPagination($model->menuTotal, $this->profile->menu_pagination_amount, 'menu_');
    	}
    	if($this->profile->thumb_pagination == 1 && $this->photoList != null )
    	{
	        $this->thumbPagination = $model->getPagination($model->thumbTotal,$this->profile->thumb_pagination_amount, 'thumb_');
    	}

		$this->thumbFiles = array();
		$this->mainFiles = array();
		$this->lboxFiles = array();
		$this->lboxThumbFiles = array();

		$this->desVars = new stdClass();
        $this->desVars->mainHasDescriptions = null;

		if( !empty($this->photoList) )
		{
            $this->desVars->mainHasDescriptions = $this->profile->show_filename == 'none' ? false : true;
    	    $this->desVars->lboxHasDescriptions = $this->profile->lbox_show_filename == 'none' ? false : true;

            $this->desVars->mainHasDescriptions = ($this->profile->allow_comments == 4 && $this->profile->comments_position == 'match_descriptions') ? true : $this->desVars->mainHasDescriptions;
            $this->desVars->lboxHasDescriptions = ($this->profile->lbox_allow_comments == 4 && $this->profile->lbox_comments_position == 'match_descriptions') ? true : $this->desVars->lboxHasDescriptions;

            if($this->profile->thumb_grid_type == 'metro' && $this->profile->thumb_layout == 'grid')
            {
                $ratios = array();
                $targetTallImages = round( count($this->photoList)/12 );
                $targetWideImages = round( count($this->photoList)/12 );
                $targetBigImages = round( count($this->photoList)/12 );

                for($i=0; $i<count($this->photoList); $i++)
                {
                    $row = $this->photoList[$i];

                    if(!empty($row->src))
                    {
                        $sourceFile = JPATH_SITE.'/'.$row->src;
                    }
                    else
                    {
                        if($row->filesys == 1)
                        {
                            $folderName = $row->folder;
                        }
                        else
                        {
                            $increment = igFileHelper::getIncrementFromFilename($row->filename);
                            $folderName = igFileHelper::getFolderName($increment);
                        }

                        $sourceFile = IG_ORIG_PATH.'/'.$folderName.'/'.$row->filename;
                    }

                    $imgSize = JFile::getExt($sourceFile) == 'svg' ? igFileHelper::getSVGdimensions($sourceFile) : getimagesize($sourceFile);
                    $ratios[$i] = $imgSize[0]/$imgSize[1];
                }

                //$ratios = igUtilityHelper::shuffleAssoc($ratios);

                asort($ratios);
                $tallIndexes = array();
                $ratiosForTall = $ratios;
                for($k=0; $k<$targetTallImages; $k++)
                {
                    $key = key($ratiosForTall);
                    $tallIndexes[] = $key;
                    unset($ratiosForTall[$key]);
                }

                arsort($ratios);
                $wideIndexes = array();
                $ratiosForWide = $ratios;
                for($k=0; $k<$targetWideImages; $k++)
                {
                    $key = key($ratiosForWide);
                    $wideIndexes[] = $key;
                    unset($ratiosForWide[$key]);
                }

                $bigIndexes = array();
                $keys = array_keys($ratios);
                for($k=0; $k<$targetBigImages; $k++)
                {
                    $index = $keys[round(count($keys)/2)];

                    $bigIndexes[] = $index;
                    unset($keys[$index]);
                    $keys = array_values($keys);
                }
            }

            $this->show_img_xtra_1 = $this->params->get('show_img_xtra_1', 0);
            $this->show_img_xtra_2 = $this->params->get('show_img_xtra_2', 0);
            $this->show_img_xtra_3 = $this->params->get('show_img_xtra_3', 0);
            $this->show_img_xtra_4 = $this->params->get('show_img_xtra_4', 0);

            for($i=0; $i<count($this->photoList); $i++)
    		{
    		    $row = $this->photoList[$i];
                $row->has_extra_fields = false;

    		    if($this->show_img_xtra_1 == 1 && !empty($row->extra_field_1)){$this->desVars->mainHasDescriptions = true;$this->desVars->lboxHasDescriptions = true;$row->has_extra_fields=true;}
                if($this->show_img_xtra_2 == 1 && !empty($row->extra_field_2)){$this->desVars->mainHasDescriptions = true;$this->desVars->lboxHasDescriptions = true;$row->has_extra_fields=true;}
                if($this->show_img_xtra_3 == 1 && !empty($row->extra_field_3)){$this->desVars->mainHasDescriptions = true;$this->desVars->lboxHasDescriptions = true;$row->has_extra_fields=true;}
                if($this->show_img_xtra_4 == 1 && !empty($row->extra_field_4)){$this->desVars->mainHasDescriptions = true;$this->desVars->lboxHasDescriptions = true;$row->has_extra_fields=true;}


                if($this->profile->show_tags == 1 || $this->profile->lbox_show_tags == 1)
                {
                    if( strlen(strval($row->tags)) > 0 )
                    {
                        $this->hasTags = true;
                        $tagsString = '<div class="ig-tags-wrapper">';
                        $tagsArray = explode(',', $row->tags);
                        for($k=0; $k<count($tagsArray); $k++)
                        {
                            $tagsString .= '<a class="ig-tags-link" href="'.JRoute::_('index.php?option=com_igallery&view=tags&igtags='.$tagsArray[$k].'&Itemid='.igUtilityHelper::getItemid($this->category->id,true)).'">'.$tagsArray[$k].'</a> ';
                        }
                        $tagsString .= '</div>';
                        $row->description .= $tagsString;
                    }

                    if($this->hasTags == true)
                    {
                        $this->desVars->mainHasDescriptions = true;
                    }
                }

                if($this->profile->thumb_grid_type == 'metro' && $this->profile->thumb_layout == 'grid')
                {
                    $smaller = min($this->profile->thumb_width,$this->profile->thumb_height);

                    $this->profile->thumb_width = $smaller;
                    $this->profile->thumb_height = $smaller;
                    $this->profile->crop_thumbs = 1;

                    $row->thumbHeightDouble = 0;
                    $row->thumbWidthDouble = 0;
                    $this->profile->crop_thumbs = 1;

                    if( in_array($i,$tallIndexes))
                    {
                        $thumbHeight = ($this->profile->thumb_height * 2) + $this->profile->thumb_grid_spacing;
                        $thumbWidth = $this->profile->thumb_width;
                        $row->thumbHeightDouble = 1;
                    }
                    else if( in_array($i,$wideIndexes))
                    {
                        $thumbWidth = ($this->profile->thumb_width * 2) + $this->profile->thumb_grid_spacing;
                        $thumbHeight = $this->profile->thumb_height;
                        $row->thumbWidthDouble = 1;
                    }
                    else if( in_array($i,$bigIndexes))
                    {
                        $thumbWidth = ($this->profile->thumb_width * 2) + $this->profile->thumb_grid_spacing;
                        $thumbHeight = ($this->profile->thumb_height * 2) + $this->profile->thumb_grid_spacing;
                        $row->thumbHeightDouble = 1;
                        $row->thumbWidthDouble = 1;
                    }
                    else
                    {
                        $thumbWidth = $this->profile->thumb_width;
                        $thumbHeight = $this->profile->thumb_height;
                    }
                }
                else
                {
                    $thumbWidth = $this->profile->thumb_width;
                    $thumbHeight = $this->profile->thumb_height;
                }

                $folderName = $row->filesys == 1 ? $row->folder : '';

    			if(! $this->thumbFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $thumbWidth,
                $thumbHeight, $this->profile->img_quality, $this->profile->crop_thumbs, $row->rotation, $this->profile->round_thumb,
                $this->profile->round_fill,$row->crop_position) )
    		    {
    		        return false;
    		    }

    		    if(! $this->mainFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $this->profile->max_width,
    		    $this->profile->max_height, $this->profile->img_quality, $this->profile->crop_main, $row->rotation, $this->profile->round_large, $this->profile->round_fill,
                $row->crop_position, $this->profile->watermark, $this->profile->watermark_text, $this->profile->watermark_text_color, $this->profile->watermark_text_size, $this->profile->watermark_filename,
    		    $this->profile->watermark_position, $this->profile->watermark_transparency, 0) )
    		    {
    		        return false;
    		    }

                if($this->profile->lightbox == 1 && $this->profile->lbox_show_thumbs == 1)
                {
                    if (!$this->lboxThumbFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $this->profile->lbox_thumb_width,
                        $this->profile->lbox_thumb_height, $this->profile->img_quality, $this->profile->lbox_crop_thumbs, $row->rotation, $this->profile->round_thumb,
                        $this->profile->round_fill, $row->crop_position)) {
                        return false;
                    }
                }

                if($this->profile->lightbox == 1)
                {
                    if (!$this->lboxFiles[$i] = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $this->profile->lbox_max_width,
                        $this->profile->lbox_max_height, $this->profile->img_quality, $this->profile->crop_lbox, $row->rotation, $this->profile->round_large, $this->profile->round_fill,
                        $row->crop_position, $this->profile->watermark, $this->profile->watermark_text, $this->profile->watermark_text_color, $this->profile->watermark_text_size, $this->profile->watermark_filename,
                        $this->profile->watermark_position, $this->profile->watermark_transparency, 0)) {
                        return false;
                    }
                }

    		    if( strlen( strval($row->description) ) > 0 )
    		    {
    		    	$this->desVars->mainHasDescriptions = true;
    		    	$this->desVars->lboxHasDescriptions = true;
    		    }

			    if($this->profile->show_exif_camera == 1 || $this->profile->show_exif_gps == 1)
			    {
				    $this->desVars->mainHasDescriptions = true;
			    }

			    if($this->profile->lbox_show_exif_camera == 1 || $this->profile->lbox_show_exif_gps == 1)
			    {
				    $this->desVars->lboxHasDescriptions = true;
			    }

                if(empty($row->alt_text))
                {
                    preg_match_all('/-[0-9]+/', $row->filename, $matches);
                    $altText = str_replace(end($matches[0]), '', $row->filename);
                    $row->alt_text = str_replace(array('_','-'),' ',JFile::stripExt($altText));
                }
    		}

		}

        $this->largestHeight = 0;
        $this->largestWidth = 0;
        $this->largestLboxHeight = 0;
        $this->largestLboxWidth = 0;

        for ($i=0; $i<count($this->mainFiles); $i++)
        {
            $this->largestWidth = $this->mainFiles[$i]['width'] > $this->largestWidth ? $this->mainFiles[$i]['width'] : $this->largestWidth;
            $this->largestHeight = $this->mainFiles[$i]['height'] > $this->largestHeight ? $this->mainFiles[$i]['height'] : $this->largestHeight;
        }

        if(!empty($this->photoList) && $this->input->get('igaddlinks', 0,'INT') == 1)
        {
            for($i=0; $i<count($this->photoList); $i++)
            {
                $row = $this->photoList[$i];

                if(strlen($row->link) < 2)
                {
                    $imgOrdering = 0;
                    if($row->image_ordering == 'new_first')
                    {
                        if(!isset(self::$imageLists[$row->gallery_id]))
                        {
                            $db	= JFactory::getDBO();
                            $query = 'SELECT id,filename,date FROM #__igallery_img WHERE gallery_id = '.(int)$row->gallery_id.' AND published = 1 ORDER BY date DESC';
                            $db->setQuery($query);
                            self::$imageLists[$row->gallery_id] = $db->loadObjectList();
                        }

                        $imgCounter = 0;
                        foreach(self::$imageLists[$row->gallery_id] as $targetGalleryImgRow)
                        {
                            $imgCounter++;
                            if($targetGalleryImgRow->id == $row->id)
                            {
                                $imgOrdering = $imgCounter;
                                break;
                            }
                        }
                    }
                    else
                    {
                        $imgOrdering = $row->ordering;
                    }

                    $limitStart = '';
                    if($row->thumb_pagination == 1)
                    {
                        if($imgOrdering > $row->thumb_pagination_amount)
                        {
                            $group = ceil($imgOrdering / $row->thumb_pagination_amount) - 1;

                            if($group > 0)
                            {
                                $limitStart = '&thumb_limitstart=' . ($group * $row->thumb_pagination_amount);
                            }
                        }
                    }

                    $fileHashNoRef = empty($row->filesys) ? '&i='.substr($row->filename, 0, strrpos($row->filename, '-')) : '&i='.JFile::stripExt($row->filename);
                    $linkItemid = igUtilityHelper::getItemid($row->gallery_id);
                    $this->photoList[$i]->link = JRoute::_('index.php?option=com_igallery&view=category&igid=' . $row->gallery_id . '&Itemid=' . $linkItemid . $limitStart . $fileHashNoRef, false);
                    $this->photoList[$i]->target_blank = 0;
                }
            }
        }

        $this->setMetaData();

		if($this->source == 'component' && ($this->input->get('view', 'category') != 'tags'))
	    {
    		igUtilityHelper::writeBreadcrumbs($this->category);
    	}

        if( ($this->profile->allow_comments == 1 || $this->profile->lbox_allow_comments == 1) && $this->params->get('comments-permission', 'registered') == 'recaptcha')
        {
            PluginHelper::importPlugin('captcha');
            $app->triggerEvent('onInit', array('dynamic_recaptcha_1'));
            $this->recaptcha = $app->triggerEvent('onDisplay', array(null, 'dynamic_recaptcha_1', 'class=""'));
        }

	    parent::display('main');
	}

	function setMetaData($onlyFramework=false)
	{
		$document = JFactory::getDocument();
		$app = JFactory::getApplication();
		JHtml::_('jquery.framework');

		$document->addStyleSheet(JURI::root(true).'/media/com_igallery/css/lib-42.css');
        $document->addStyleSheet(JURI::root(true).'/media/com_igallery/css/ignitegallery-42.css');
        $document->addScript(JURI::root(true).'/media/com_igallery/js/lib-42.js');
        $document->addScript(JURI::root(true).'/media/com_igallery/js/ignitegallery-42.js');

        if($onlyFramework==false)
        {
            $metaData = $this->getMetaData();

            if(isset($metaData['title']))
            {
                if( $app->getCfg('sitename_pagetitles', 0) == 1 )
                {
                    $pageTitle = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $metaData['title']);
                }
                elseif($app->getCfg('sitename_pagetitles', 0) == 2)
                {
                    $pageTitle = JText::sprintf('JPAGETITLE', $metaData['title'], $app->getCfg('sitename'));
                }
                else
                {
                    $pageTitle = $metaData['title'];
                }

                $document->addCustomTag('<meta property="og:title" content="'.$pageTitle.'" />');
                $document->setTitle($pageTitle);

            }

            if(isset($metaData['description']))
            {
                if(function_exists('mb_substr'))
                {
                    $ogDescription = mb_substr( strip_tags( str_replace('"','\'',html_entity_decode($metaData['description'], ENT_QUOTES, 'UTF-8') ) ), 0, 200 );
                }
                else
                {
                    $ogDescription = substr( strip_tags( str_replace('"','\'',html_entity_decode($metaData['description'], ENT_QUOTES, 'UTF-8') ) ), 0, 200 );
                }

                $document->setDescription($ogDescription);
                $document->addCustomTag('<meta property="og:description" content="'.$ogDescription.'" />');
            }

            if(isset($metaData['image']))
            {
                $metaTag = '<meta property="og:image" content="'.$metaData['image'].'" />';
                $document->addCustomTag($metaTag);

                if(isset($metaData['imageWidth']))
                {
                    $metaTag = '<meta property="og:image:width" content="'.$metaData['imageWidth'].'" />';
                    $document->addCustomTag($metaTag);
                }
                if(isset($metaData['imageHeight']))
                {
                    $metaTag = '<meta property="og:image:height" content="'.$metaData['imageHeight'].'" />';
                    $document->addCustomTag($metaTag);
                }
            }
        }
	}

	function getMetaData()
	{
		$metaData = array();
        $imgParam = $this->input->get('img', 0,'INT');
        if(!empty($imgParam))
        {
            $db = JFactory::getDBO();
            $query = $db->getQuery(true);

            $query->select('i.id, i.filename, i.alt_text, i.description, i.gallery_id, i.ordering, i.rotation, i.crop_position, i.filesys, i.src');
            $query->from('#__igallery_img AS i');
            $query->select('c.profile,c.folder');
            $query->join('INNER', '`#__igallery` AS c ON c.id = i.gallery_id');
            $query->select('p.lbox_max_width, p.lbox_max_height, p.img_quality, p.crop_lbox, p.round_large, p.round_fill');
            $query->join('INNER', '`#__igallery_profiles` AS p ON p.id = c.profile');
            $query->where('i.id ='.(int)$imgParam);
            $db->setQuery($query);
            $row = $db->loadObject();

            $folderName = $row->filesys == 1 ? $row->folder : '';
            $lboxFile = igFileHelper::originalToResized($row->filename, $folderName, $row->src, $row->lbox_max_width,
            $row->lbox_max_height, $row->img_quality, $row->crop_lbox, $row->rotation, $row->round_large, $row->round_fill,
            $row->crop_position);

            $metaData['image'] = $lboxFile['baseFolderNameAbsolute'].$lboxFile['folderName'].'/'.$lboxFile['fullFileName'];
            $metaData['imageWidth'] = $lboxFile['width'];
            $metaData['imageHeight'] = $lboxFile['height'];

            if(!empty($row->alt_text))
            {
                $metaData['title'] = $row->alt_text;
            }
            else
            {
                preg_match_all('/-[0-9]+/', $row->filename, $matches);
                $altText = str_replace($matches[0][0], '', $row->filename);
                $metaData['title'] = str_replace(array('_','-'),' ',JFile::stripExt($altText));
            }
            if(!empty($row->description))
            {
                $metaData['description'] = $row->description;
            }
        }

        if( empty($this->ajaxUrlImageName) )
        {
            if(!empty($this->urlImageName))
            {
                $this->ajaxUrlImageName = $this->urlImageName;
            }
        }

		if(!empty($this->ajaxUrlImageName) && !empty($this->photoList) && !isset($metaData['image']))
		{
			for($i=0; $i<count($this->photoList); $i++)
			{
				$row = $this->photoList[$i];
				$fileNameNoRef = empty($row->filesys) ? substr($row->filename, 0, strrpos($row->filename, '-')) : JFile::stripExt($row->filename);

				if( ($fileNameNoRef == $this->ajaxUrlImageName) || (str_replace('_','-',$fileNameNoRef) == $this->ajaxUrlImageName) )
				{
					$this->activeImage = $i;

				    if(isset($this->lboxFiles[$i]))
                    {
                        if(file_exists($this->lboxFiles[$i]['baseFolderServerPath'].'/'.$this->lboxFiles[$i]['folderName'].'/'.$this->lboxFiles[$i]['fullFileName']))
                        {
                            $metaData['image'] = $this->lboxFiles[$i]['baseFolderNameAbsolute'].$this->lboxFiles[$i]['folderName'].'/'.$this->lboxFiles[$i]['fullFileName'];
                            $metaData['imageWidth'] = $this->lboxFiles[$i]['width'];
                            $metaData['imageHeight'] = $this->lboxFiles[$i]['height'];
                        }
                    }

				    if(!isset($metaData['image']))
                    {
                        $metaData['image'] = $this->mainFiles[$i]['baseFolderNameAbsolute'].$this->mainFiles[$i]['folderName'].'/'.$this->mainFiles[$i]['fullFileName'];
                        $metaData['imageWidth'] = $this->mainFiles[$i]['width'];
                        $metaData['imageHeight'] = $this->mainFiles[$i]['height'];
                    }


					if(!empty($this->photoList[$i]->alt_text))
					{
						$metaData['title'] = $this->photoList[$i]->alt_text;
					}

					if(!empty($this->photoList[$i]->description))
					{
						$metaData['description'] = $this->photoList[$i]->description;
					}

					break;
				}
			}
		}

		if($this->source == 'component')
	    {
			if(!isset($metaData['title']) && strlen($this->category->page_title) > 1)
			{
				$metaData['title'] = $this->category->page_title;
			}

			if(!isset($metaData['title']) && strlen($this->category->name) > 1)
			{
				$metaData['title'] = $this->category->name;
			}


			if(!isset($metaData['description']) && strlen($this->category->metadesc) > 1)
			{
				$metaData['description'] = 	$this->category->metadesc;
			}

			if(!isset($metaData['description']) && strlen($this->category->gallery_description) > 1)
			{
				$metaData['description'] = 	$this->category->gallery_description;
			}

            if(!isset($metaData['description']) && strlen($this->category->menu_description) > 1)
            {
                $metaData['description'] = 	$this->category->menu_description;
            }

            if( !isset($metaData['image']) )
            {
                if(isset($this->lboxFiles[0]['folderName']))
                {
                    $metaData['image'] = $this->lboxFiles[0]['baseFolderNameAbsolute'].$this->lboxFiles[0]['folderName'].'/'.$this->lboxFiles[0]['fullFileName'];
                }
                else if(isset($this->mainFiles[0]['folderName']))
                {
                    $metaData['image'] = $this->mainFiles[0]['baseFolderNameAbsolute'].$this->mainFiles[0]['folderName'].'/'.$this->mainFiles[0]['fullFileName'];
                }
                else if(!empty($this->category->menu_image_filename))
                {
                    if($this->category->filesys == 1)
                    {
                        $folderName = $this->category->folder;
                    }
                    else
                    {
                        $increment = igFileHelper::getIncrementFromFilename($this->category->menu_image_filename);
                        $folderName = igFileHelper::getFolderName($increment);
                    }

                    $metaData['image'] = IG_IMAGE_HTML_ORIG.$folderName.'/'.$this->category->menu_image_filename;
                }
            }
		}

		return $metaData;
	}

    function removeCanonical()
	{
		/*canonical tags stop the gallery facebook share button working*/
	    $document = JFactory::getDocument();

		foreach($document->_links as $key => $value)
		{
			if($value['relation'] == 'canonical')
			{
				unset($document->_links[$key]);
			}
		}

	}



}

class igViewcategory extends igalleryViewcategory{}
